<?php

/**
 * bbPress Replies
 */

add_filter('bbp_show_lead_topic', function () {
	$show_lead[] = 'true';
	return $show_lead;
});

/**
 * Include bbPress 'topic' custom post type in WordPress' search results
 */
function ntwb_bbp_topic_cpt_search( $topic_search ) {
	$topic_search['exclude_from_search'] = false;
	return $topic_search;
}
add_filter( 'bbp_register_topic_post_type', 'ntwb_bbp_topic_cpt_search' );

/**
 * Include bbPress 'forum' custom post type in WordPress' search results
 * @param $forum_search
 * @return mixed
 */
function ntwb_bbp_forum_cpt_search( $forum_search ) {
	$forum_search['exclude_from_search'] = false;
	return $forum_search;
}
add_filter( 'bbp_register_forum_post_type', 'ntwb_bbp_forum_cpt_search' );

/**
 * Include bbPress 'reply' custom post type in WordPress' search results
 * @param $reply_search
 * @return mixed
 */
function ntwb_bbp_reply_cpt_search( $reply_search ) {
	$reply_search['exclude_from_search'] = false;
	return $reply_search;
}
add_filter( 'bbp_register_reply_post_type', 'ntwb_bbp_reply_cpt_search' );

/**
 * bbPress User Role
 */
function docy_bbp_user_role_icon() {
	$author_role = bbp_get_user_display_role( bbp_get_reply_author_id() );
	switch ( $author_role ) {
		case 'Keymaster':
			Docy_helper()->image_from_settings( 'keymaster_icon' );
			break;
		case 'Moderator':
			Docy_helper()->image_from_settings( 'moderator_icon' );
			break;
		case 'Participant':
			Docy_helper()->image_from_settings( 'participant_icon' );
			break;
		case 'Spectator':
			Docy_helper()->image_from_settings( 'spectator_icon' );
			break;
		case 'Blocked':
			Docy_helper()->image_from_settings( 'blocked_icon' );
			break;
	}
}

/**
 * Get author role
 */
function docy_get_bbp_user_role() {
	$role = bbp_get_topic_author_role( array(
		'topic_id' => get_the_ID(),
		'before'   => '',
		'after'    => '',
	));
	return $role;
}

/**
 * Get topic reply count
 */
function docy_topic_reply_count() {
	$get_reply = get_post_meta( get_the_ID(), '_bbp_reply_count', true );
	$_reply_count = isset( $get_reply ) && !empty( $get_reply ) ? $get_reply : 0;
	echo esc_html( $_reply_count );
}

/**
 * Remove character "|" showing on click before to the subscription button
 * @param $args
 * @return array|mixed
 */
add_filter ('bbp_before_get_user_subscribe_link_parse_args', function ($args = array() ) {
    $args['before'] = '';
    return $args;
});

/**
 * Display bbp_reply_admin_links() as a dropdown list. The dropdown will be shown on click on a vertical three dots icon.
 * Create a new function to display the dropdown.
 */
function docy_get_reply_admin_links( $args = array() ) {

    // Parse arguments against default values
    $r = bbp_parse_args( $args, array(
        'id'     => 0,
        'before' => '<div class="bbp-admin-links-dropdown">',
        'after'  => '</div>',
        'sep'    => '',
        'links'  => array()
    ), 'get_reply_admin_links' );

    $r['id'] = bbp_get_reply_id( $r['id'] );

    // If post is a topic, return the topic admin links instead
    if ( bbp_is_topic( $r['id'] ) ) {
        return docy_get_topic_admin_links( $args );
    }

    // If post is not a reply, return
    if ( ! bbp_is_reply( $r['id'] ) ) {
        return;
    }

    // If topic is trashed, do not show admin links
    if ( bbp_is_topic_trash( bbp_get_reply_topic_id( $r['id'] ) ) ) {
        return;
    }

    // If no links were passed, default to the standard
    if ( empty( $r['links'] ) ) {
        $r['links'] = apply_filters( 'bbp_reply_admin_links', array(
            'edit'    => bbp_get_reply_edit_link   ( $r ),
            'move'    => bbp_get_reply_move_link   ( $r ),
            'split'   => bbp_get_topic_split_link  ( $r ),
            'trash'   => bbp_get_reply_trash_link  ( $r ),
            'spam'    => bbp_get_reply_spam_link   ( $r ),
            'approve' => bbp_get_reply_approve_link( $r ),
            'reply'   => bbp_get_reply_to_link     ( $r )
        ), $r['id'] );
    }

    // See if links need to be unset
    $reply_status = bbp_get_reply_status( $r['id'] );
    if ( in_array( $reply_status, array( bbp_get_spam_status_id(), bbp_get_trash_status_id(), bbp_get_pending_status_id() ), true ) ) {

        // Spam link shouldn't be visible on trashed topics
        if ( bbp_get_trash_status_id() === $reply_status ) {
            unset( $r['links']['spam'] );

        // Trash link shouldn't be visible on spam topics
        } elseif ( bbp_get_spam_status_id() === $reply_status ) {
            unset( $r['links']['trash'] );
        }
    }

    // Build our dropdown menu structure
    $menu = '<select name="reply-admin-links" class="nice-select bbp-admin-dropdown-menu" onchange="if(this.value) window.location.href=this.value;">';

    // Process each link as a menu item
    $menu .= '<option value="" disabled selected>' . esc_html__( 'Select an option', 'docy' ) . '</option>';
    foreach ( array_filter( $r['links'] ) as $link ) {
        // Extract href attribute from the link
        preg_match('/href=(["\'])([^"\']+)\\1/', $link, $matches);
        $href = !empty($matches[2]) ? $matches[2] : '';

        // Add the option with value attribute containing the URL
        $menu .= '<option value="' . esc_url($href) . '" class="bbp-admin-dropdown-item">' . wp_strip_all_tags($link) . '</option>';
    }

    $menu .= '</select>';

    $retval = $r['before'] . $menu . $r['after'];

    // Filter & return
	if ( is_user_logged_in() ) {
		return apply_filters( 'docy_bbp_get_reply_admin_links', $retval, $r, $args );
	}
}

/**
 * Similar function for topics - to handle the case where a topic is passed to the reply function
 */
function docy_get_topic_admin_links( $args = array() ) {
    // Parse arguments against default values
    $r = bbp_parse_args( $args, array(
        'id'     => 0,
        'before' => '<div class="bbp-admin-links-dropdown">',
        'after'  => '</div>',
        'sep'    => '',
        'links'  => array()
    ), 'get_topic_admin_links' );

    $r['id'] = bbp_get_topic_id( $r['id'] );

    // If not a topic, then return
    if ( ! bbp_is_topic( $r['id'] ) ) {
        return;
    }

    // If no links were passed, get the default ones
    if ( empty( $r['links'] ) ) {
        $r['links'] = apply_filters( 'bbp_topic_admin_links', array(
            'edit'    => bbp_get_topic_edit_link   ( $r ),
            'close'   => bbp_get_topic_close_link  ( $r ),
            'stick'   => bbp_get_topic_stick_link  ( $r ),
            'merge'   => bbp_get_topic_merge_link  ( $r ),
            'trash'   => bbp_get_topic_trash_link  ( $r ),
            'spam'    => bbp_get_topic_spam_link   ( $r ),
            'approve' => bbp_get_topic_approve_link( $r ),
            'reply'   => bbp_get_topic_reply_link  ( $r )
        ), $r['id'] );
    }

    // See if links need to be unset
    $topic_status = bbp_get_topic_status( $r['id'] );
    if ( in_array( $topic_status, array( bbp_get_spam_status_id(), bbp_get_trash_status_id(), bbp_get_pending_status_id() ), true ) ) {

        // Spam link shouldn't be visible on trashed topics
        if ( bbp_get_trash_status_id() === $topic_status ) {
            unset( $r['links']['spam'] );

        // Trash link shouldn't be visible on spam topics
        } elseif ( bbp_get_spam_status_id() === $topic_status ) {
            unset( $r['links']['trash'] );
        }
    }

    // Build our dropdown menu structure
    $menu = '<select name="topic-admin-links" class="nice-select bbp-admin-dropdown-menu" onchange="if(this.value) window.location.href=this.value;">';
    $menu .= '<option value="" disabled selected>Select an option</option>';

    // Process each link as a menu item
    foreach ( array_filter( $r['links'] ) as $link ) {
        // Extract href attribute from the link
        preg_match('/href=(["\'])([^"\']+)\\1/', $link, $matches);
        $href = !empty($matches[2]) ? $matches[2] : '';

        // Add the option with value attribute containing the URL
        $menu .= '<option value="' . esc_url($href) . '" class="bbp-admin-dropdown-item">' . wp_strip_all_tags($link) . '</option>';
    }

    $menu .= '</select>';

    $retval = $r['before'] . $menu . $r['after'];

    // Filter & return
    return apply_filters( 'docy_bbp_get_topic_admin_links', $retval, $r, $args );
}
/**
 * Enqueue the script for sorting bbPress replies
 */

function docy_enqueue_bbp_replies_sorting_script() {
	wp_localize_script('bbp-replies-sorting', 'bbp_reply_ajax_obj', array(
		'ajax_url' => admin_url('admin-ajax.php'),
		'bbp_topic_id' => get_the_ID(),
	));
}
add_action('wp_enqueue_scripts', 'docy_enqueue_bbp_replies_sorting_script');

add_action('wp_ajax_sort_bbp_replies', 'docy_ajax_sort_bbp_replies');
add_action('wp_ajax_nopriv_sort_bbp_replies', 'docy_ajax_sort_bbp_replies');
function docy_ajax_sort_bbp_replies() {
	if (empty($_POST['topic_id'])) {
		wp_send_json_error(['message' => 'No topic ID provided.']);
	}
	$topic_id = intval($_POST['topic_id']);
	$sort = isset($_POST['sort']) ? sanitize_text_field($_POST['sort']) : 'desc';
	// Set $_GET['sort'] for the filter to pick up
	$_GET['sort'] = $sort;

	// Start output buffering to capture the replies loop HTML
	ob_start();
	// Set up bbPress replies loop manually for AJAX context
	$replies_args = array(
		'post_parent' => $topic_id,
		'post_type' => bbp_get_reply_post_type(),
		'orderby' => ($sort === 'vote' ? 'meta_value_num' : 'date'),
		'order' => ($sort === 'asc' ? 'ASC' : 'DESC'),
		'meta_key' => ($sort === 'vote' ? 'bbp_voting_score' : ''),
		'posts_per_page' => -1,
	);
	if (bbp_has_replies($replies_args)) {
		while (bbp_replies()) : bbp_the_reply();
			include get_template_directory() . '/bbpress/loop-single-reply.php';
			endwhile;
	} else {
		echo '<div>No replies found.</div>';
	}
	$html = ob_get_clean();

	wp_send_json_success(['html' => $html]);
}
