<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

    if ( ! empty( $settings['box_link']['url'] ) ) {
        $this->add_link_attributes( 'box_link', $settings['box_link'] );
    }


    $this->add_render_attribute( 'box_wrapper', 'class', 'sp_box_hover variation_one' );
    // Check the selected image alignment and add corresponding class
    $image_alignment = $settings['image_alignment'];
    if ( 'right' === $image_alignment ) {
        $this->add_render_attribute( 'box_wrapper', 'class', 'image_right' );
    } elseif ( 'left' === $image_alignment ) {
        $this->add_render_attribute( 'box_wrapper', 'class', 'image_left' );
    }

?>


<a <?php $this->print_render_attribute_string( 'box_wrapper' ); ?> <?php $this->print_render_attribute_string( 'box_link' ); ?>  class="sp_box_hover variation_one">
    <?php if ( ! empty( $settings['box_image']['id'] ) ) : ?>
        <div class="box_img wow fadeIn">
            <?php echo wp_get_attachment_image( $settings['box_image']['id'], 'full' ) ?>
        </div>
    <?php endif; ?>
    <div class="box_hover_content">
        <?php
        if ( ! empty( $settings['box_title'] ) ) { ?>
            <div class="text_top">
                <h3><?php echo spel_kses_post( nl2br( $settings['box_title'] ) ) ?></h3>
            </div>
            <?php
        }
        if ( ! empty( $settings['box_description'] ) ) { ?>
            <div class="text_two">
                <p class="description wow fadeInUp" data-wow-delay="0.5s">
                    <?php echo spel_kses_post( $settings['box_description'] ) ?>
                </p>
            </div>
            <?php
        }
        ?>
    </div>
</a>
