<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
?>

<div class="spel-accordion-article-wrap">
	<?php
	if ( is_array( $taxonomy ) && count( $taxonomy ) > 0 ) {
		foreach ( $taxonomy as $key => $item ) {
			$cat_id = $item->slug;
			?>
            <div class="article-inner">

                <a href="#toggle-<?php echo esc_attr( $cat_id ); ?>" class="tab-title<?php echo esc_attr($is_active); echo esc_attr($icon_align_class); ?>">
					<?php

                    echo esc_html( $item->name );

                    if ( ! empty( $settings['plus_icon']['value'] ) || ! empty( $settings['minus_icon']['value'] ) ) { ?>
                        <span class="icon-wrapper">
                            <span class="plus-icon">
                                <?php \Elementor\Icons_Manager::render_icon( $settings['plus_icon'] ); ?>
                            </span>
                            <span class="minus-icon">
                                <?php \Elementor\Icons_Manager::render_icon( $settings['minus_icon'] ); ?>
                            </span>
                        </span>
                        <?php
                    }

                    ?>
                </a>

                <div class="multi-collapse<?php echo esc_attr($is_show) ?>" id="toggle-<?php echo esc_attr( $cat_id ); ?>">
                    <div class="card-body bs-sm">
                        <div class="ezd-grid ezd-grid-cols-12">
							<?php
							$args = [
								'post_type'   => 'post',
								'post_status' => 'publish',
							];

							if ( ! empty( $show_count ) ) {
								$args['posts_per_page'] = $show_count;
							}

							if ( ! empty( $order ) ) {
								$args['order'] = $order;
							}

							if ( ! empty( $orderby ) ) {
								$args['orderby'] = $orderby;
							}

							if ( ! empty( $exclude ) ) {
								$args['post__not_in'] = $exclude;
							}

							$args['tax_query'] = [
								[
									'taxonomy'         => 'category',
									'field'            => 'term_id',
									'terms'            => $item->term_id,
									'include_children' => false
								]
							];

							$cat_posts = new \WP_Query( $args );

							while ( $cat_posts->have_posts() ) : $cat_posts->the_post();
								?>
                                <div class="ezd-lg-col-<?php echo esc_attr( $column_grid ); ?>">
                                    <div class="accordion-article-item">
                                        <a href='<?php the_permalink(); ?>'>
                                            <h4 class="post_title"><?php echo spel_get_title_length( $settings, 'title_length' ); ?></h4>
                                        </a>
                                        <p><?php echo spel_get_excerpt_length( $settings, 'excerpt_length' ); ?></p>
                                        <ul class="post-meta ezd-list-unstyled">
                                            <li class="reading-titme"><?php echo spel_get_reading_time(); ?></li>
                                            <li class="article-date">|</li>
                                            <li class="article-date"><?php echo get_the_time( get_option( 'date_format' ) ) ?></li>
                                        </ul>
                                    </div>
                                </div>
							    <?php
							endwhile;
							wp_reset_postdata();
							?>
                        </div>
                    </div>
                </div>

            </div>
			<?php
		}
	}
	?>
</div>