<?php
/**
 * Use namespace to avoid conflict
 */

namespace SPEL_PRO\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;


if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Class Skill_Showcase
 * @package spider\Widgets
 */
class Skill_Showcase extends Widget_Base {

	public function get_name(): string {
		return 'spe_skill_showcase_widget'; // ID of the widget (Don't change this name)
	}

	public function get_title(): string
    {
		return esc_html__( 'Skill Showcase', 'spider-elements-pro' );
	}

	public function get_icon(): string
    {
		return 'eicon-slideshow spel-icon';
	}

	public function get_categories(): array
    {
		return [ 'spider-element-pro' ];
	}

	/**
	 * Name: get_style_depends()
	 * Desc: Register the required CSS dependencies for the frontend.
	 */
	public function get_style_depends(): array
    {
		return [ 'spel-main-pro' ];
	}

	/**
	 * Name: register_controls()
	 * Desc: Register controls for these widgets
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @spider-elements
	 * Author: spider-themes
	 */
	protected function register_controls(): void
    {
		$this->elementor_content_control();
		$this->elementor_style_control();
	}


	/**
	 * Name: elementor_content_control()
	 * Desc: Register the Content Tab output on the Elementor editor.
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @spider-elements
	 * Author: spider-themes
	 */
	public function elementor_content_control(): void
    {

		//=================== Skill Showcase Text ===================//
		$this->start_controls_section(
			'section_skills',
			[
				'label' => __( 'Skills', 'spider-elements-pro' ),
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'name',
			[
				'label'       => __( 'Skill Name', 'spider-elements-pro' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => __( 'Skill Name', 'spider-elements-pro' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'size',
			[
				'label'   => __( 'Size', 'spider-elements-pro' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'default' => __( 'Default', 'spider-elements-pro' ),
					'small'   => __( 'Small', 'spider-elements-pro' ),
					'big'     => __( 'Big', 'spider-elements-pro' ),
				],
				'default' => 'default',
			]
		);

		$this->add_control(
			'skills_list',
			[
				'label'       => __( 'Skills List', 'spider-elements-pro' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => [
					[
						'name' => __( 'Html', 'spider-elements-pro' ),
						'size' => 'default',
					],
					[
						'name' => __( 'Css', 'spider-elements-pro' ),
						'size' => 'default',
					],
					[
						'name' => __( 'Java', 'spider-elements-pro' ),
						'size' => 'default',
					]
				],
				'title_field' => '{{{ name }}}',
			]
		);

		$this->end_controls_section();
	} //End Skill Showcase Text


	/**
	 * Name: elementor_style_control()
	 * Desc: Register the Style Tab output on the Elementor editor.
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @spider-elements
	 * Author: spider-themes
	 */
	public function elementor_style_control(): void
    {

		//============================= Skill Showcase Style =============================//
		$this->start_controls_section(
			'skill_showcase_text', [
				'label' => esc_html__( 'Skill Showcase', 'spider-elements-pro' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'     => 'showcase_text_typography',
				'selector' => '{{WRAPPER}} .skill-showcase span',
			]
		);

		$this->add_control(
			'skill_text_color',
			[
				'label'     => esc_html__( 'Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .skill-showcase span' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section(); //End Skill Showcase style

	}


	/**
	 * Name: elementor_render()
	 * Desc: Render the widget output on the frontend.
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @spider-elements
	 * Author: spider-themes
	 */
	protected function render(): void
    {
		$settings = $this->get_settings_for_display();

		if ( !empty( $settings['skills_list'] ) ) {
            ?>
            <div class="skill-showcase">
                <?php
                foreach ( $settings['skills_list'] as $skill ) {
                    if ( $skill['size'] === 'default' ) {
                        echo '<span>' . esc_html( $skill['name'] ) . '</span>';
                    } elseif ( $skill['size'] === 'small' ) {
                        echo '<span class="small">' . esc_html( $skill['name'] ) . '</span>';
                    } elseif ( $skill['size'] === 'big' ) {
                        echo '<span class="big">' . esc_html( $skill['name'] ) . '</span>';
                    }
                }
                ?>
            </div>
            <?php
        }
	}

}