<?php

/**
 * Use namespace to avoid conflict
 */

namespace SPEL_PRO\Widgets;

use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;

// Exit if accessed directly
if (!defined('ABSPATH')) {
	exit;
}

/**
 * Class Timeline
 * @package spider\Widgets
 */
class Marquee_Slider extends Widget_Base {

	public function get_name(): string
    {
		return 'spel_marquee_slider'; // ID of the widget (Don't change this name)
	}

	public function get_title(): string
    {
		return esc_html__( 'Marquee Slides', 'spider-elements-pro' );
	}

	public function get_icon(): string
    {
		return 'eicon-slider-push spel-icon';
	}

	public function get_categories (): array
    {
		return [ 'spider-element-pro' ];
	}

	/**
	 * Name: get_style_depends()
	 * Desc: Register the required CSS dependencies for the frontend.
	 */
	public function get_style_depends(): array
    {
		return [ 'slick-theme', 'slick', 'spel-main-pro' ];
	}

	/**
	 * Name: get_script_depends()
	 * Desc: Register the required JS dependencies for the frontend.
	 */
	public function get_script_depends(): array
    {
		return [ 'slick', 'spel-el-pro-widgets' ];
	}


	/**
	 * Name: register_controls()
	 * Desc: Register controls for these widgets
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @spider-elements
	 * Author: spider-themes
	 */
	protected function register_controls(): void
    {
		$this->elementor_content_control();
		$this->elementor_style_control();
	}

	/**
	 * Name: elementor_content_control()
	 * Desc: Register the Content Tab output on the Elementor editor.
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @spider-elements
	 * Author: spider-themes
	 */
	protected function elementor_content_control(): void
    {

		//========================= Preset Style ======================//
		$this->start_controls_section(
			'select_marquee_style', [
				'label' => esc_html__( 'Preset Skins', 'spider-elements-pro' ),
			]
		);

		$this->add_control(
			'style', [
				'label'   => esc_html__( 'Marquee Slides', 'spider-elements-pro' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'1' => [
						'icon'  => 'marquee_slides_1',
						'title' => esc_html__( '01 : Marquee Slides', 'spider-elements-pro' ),
					],
					'2' => [
						'icon'  => 'marquee_slides_2',
						'title' => esc_html__( '02 : Marquee Slides', 'spider-elements-pro' )
					],
					'3' => [
						'icon'  => 'marquee_slides_3',
						'title' => esc_html__( '03 : Marquee Slides', 'spider-elements-pro' ),
					],
				],
				'default' => '1',
			]
		);

		$this->end_controls_section(); // End Preset style


		//===================== Marquee slides =======================//
		$this->start_controls_section(
			'contents_sec',
			[
				'label' => esc_html__( 'Contents', 'spider-elements-pro' ),
			]
		);

        $this->add_control(
            'items_per_row', [
                'label'       => esc_html__('Items Per Row', 'spider-elements-pro'),
                'type'        => \Elementor\Controls_Manager::NUMBER,
                'min'         => 1,
                'max'         => 50,
                'default'     => 10,
                'description' => esc_html__('Set the number of items displayed in a single row.', 'spider-elements-pro'),
                'condition'   => [
                    'style' => [ '1', '2' ]
                ]
            ]
        );

		//=== Marquee Repeater List
		$repeater = new Repeater();
		$repeater->add_control(
			'logo', [
				'label'      => esc_html__( 'Logo', 'spider-elements-pro' ),
				'type'       => Controls_Manager::MEDIA,
				'show_label' => true,
			]
		);

		$repeater->add_control(
			'title', [
				'label'       => esc_html__( 'Title', 'spider-elements-pro' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => esc_html__( 'Github', 'spider-elements-pro' ),
                'description' => __('<strong>Note: </strong>This field is used for Presets 01 and 02.', 'spider-elements-pro')
			]
		);

		$repeater->add_control(
			'subtitle', [
				'label'       => esc_html__( 'Subtitle', 'spider-elements-pro' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => esc_html__( 'File Management', 'spider-elements-pro' ),
                'description' => __('<strong>Note: </strong>This field is only used for Preset 01.', 'spider-elements-pro')
			]
		);

		$repeater->add_control(
			'link', [
				'label'       => esc_html__( 'Link', 'spider-elements-pro' ),
				'type'        => Controls_Manager::URL,
				'default'     => [
					'url'         => ''
				],
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
			]
		);

		$this->add_control(
			'marquee_slider', [
				'label'         => esc_html__( 'Add Brand Name', 'spider-elements-pro' ),
				'type'          => Controls_Manager::REPEATER,
				'fields'        => $repeater->get_controls(),
				'title_field'   => '{{{ title }}}',
				'prevent_empty' => false,
				'default'       => [
					[
						'title' => esc_html__( 'Github', 'spider-elements-pro' ),
						'subtitle' => esc_html__( 'File Management', 'spider-elements-pro' ),
					],
				],
			]
		); // End Marquee Repeater List

		$this->end_controls_section(); //End Marquee Slides

	}

	/**
	 * Name: elementor_style_control()
	 * Desc: Register style content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @allfolio
	 * Author: spider-themes
	 */
	public function elementor_style_control(): void
    {


        //=========================== Style Contents ==========================//
		$this->start_controls_section(
			'style_contents', [
				'label'     => esc_html__( 'Contents', 'spider-elements-pro' ),
				'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'style' => ['1', '3']
				]
			]
		);

        //=== Logo Options
        $this->add_control(
            'logo_heading', [
                'label'=> esc_html__('Logo Options', 'spider-elements-pro'),
                'type' => Controls_Manager::HEADING,
                'separator'  => 'before',
                'condition' => [
                    'style' => ['3']
                ]
            ]
        );

	    $this->add_responsive_control(
		    'logo_space', [
			    'label'      => esc_html__( 'Spacing', 'spider-elements-pro' ),
			    'type'       => Controls_Manager::SLIDER,
			    'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
			    'default'    => [
				    'size' => 12,
			    ],
			    'range'      => [
				    'px'  => [
					    'max' => 200,
				    ],
				    'em'  => [
					    'max' => 10,
				    ],
				    'rem' => [
					    'max' => 10,
				    ],
			    ],
			    'selectors'  => [
				    '{{WRAPPER}} .marquee-slider-three .marquee_inner .slide .marquee_item .title img' => 'margin-right: {{SIZE}}{{UNIT}}',
			    ],
			    'condition' => [
				    'style' => ['3'],
			    ]
		    ]
	    );


        //=== Title Options
		$this->add_control(
			'title_heading', [
				'label'=> esc_html__('Title Options', 'spider-elements-pro'),
				'type' => Controls_Manager::HEADING,
				'separator'  => 'before',
				'condition' => [
					'style' => ['3']
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'     => 'title_typo',
				'selector' => '{{WRAPPER}} .marquee-slider-three .marquee_item .title',
				'condition' => [
					'style' => ['3']
				]
			]
		);

		$this->add_control(
			'title_color', [
				'label'     => esc_html__( 'Text Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .marquee-slider-three .marquee_item .title' => 'color: {{VALUE}};',
				],
				'condition' => [
					'style' => ['3']
				]
			]
		);

        //=== Marquee Item Box Tabs
		$this->start_controls_tabs(
			'style_item_box_tabs', [
				'condition' => [
					'style' => ['1'],
					'style!' => ['2', '3']
				],
			]
		);

        //== Item Normal Tab
		$this->start_controls_tab(
			'item_box_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'spider-elements-pro' ),
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(), [
				'name' => 'item_box_normal_bg_color',
				'types' => [ 'classic', 'gradient' ],
				'exclude' => [ 'image' ],
				'selector' => '{{WRAPPER}} .slide .marquee_item',
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(), [
				'name'     => 'item_box_normal_shadow',
				'selector' => '{{WRAPPER}} .slide .marquee_item',
			]
		);

		$this->end_controls_tab(); //End normal tab

        //== Item Hover Tab
		$this->start_controls_tab(
			'item_box_hover_tab',
			[
				'label' => esc_html__( 'Hover', 'spider-elements-pro' ),
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(), [
				'name' => 'item_box_hover_bg_color',
				'types' => [ 'classic', 'gradient' ],
				'exclude' => [ 'image' ],
				'selector' => '{{WRAPPER}} .slide-row .slide .marquee_item:hover',
			]
		);

		$this->add_control(
			'item_box_hover_title', [
				'label'     => esc_html__( 'Text Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .marquee-slider-one .marquee_item:hover .contents .title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'item_box_hover_desc_color', [
				'label'     => esc_html__( 'Description Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .marquee-slider-one .marquee_item:hover .contents .desc' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(), [
				'name'     => 'item_box_hover_shadow',
				'selector' => '{{WRAPPER}} .slide .marquee_item:hover',
			]
		);

		$this->end_controls_tab(); //End hover tab
		$this->end_controls_tabs(); // End Marquee Item Box Tabs

		$this->add_control(
			'item_padding', [
				'label'      => esc_html__( 'Padding', 'spider-elements-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'separator'  => 'before',
				'selectors'  => [
					'{{WRAPPER}} .slide .marquee_item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'style' => ['1'],
					'style!' => ['3']
				]
			]
		);

		$this->end_controls_section(); //End Style Contents


        //=========================== Style Background ==========================//
        $this->start_controls_section(
            'style_background', [
                'label'     => esc_html__( 'Background', 'spider-elements-pro' ),
                'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'style' => ['3']
                ]
            ]
        );

        $this->add_control(
            'sec_padding', [
                'label'      => esc_html__( 'Padding', 'spider-elements-pro' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .marquee-slider-three' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(), [
                'name' => 'sec_bg_color',
                'types' => [ 'classic', 'gradient' ],
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .marquee-slider-three',
            ]
        );

        $this->end_controls_section(); // End Background Style

	}

	/**
	 * Name: elementor_render()
	 * Desc: Render the widget output on the frontend.
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @spider-elements
	 * Author: spider-themes
	 */
	protected function render(): void
    {
		$settings = $this->get_settings_for_display();
		extract( $settings ); //extract all settings array to variables converted to name of key

        //======================== Template Parts ==========================//
		include "templates/marquee/marquee-{$settings['style']}.php";

	}
}
