<?php

/**
 * Use namespace to avoid conflict
 */

namespace SPEL_PRO\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class Quote
 * @package spider\Widgets
 */
class Image_Hover extends Widget_Base {

	public function get_name(): string
    {
		return 'docy_image_hover';
	}

	public function get_title(): string
    {
		return esc_html__( 'Image Hover', 'spider-elements-pro' );
	}

	public function get_icon(): string
    {
		return 'eicon-image-rollover spel-icon';
	}

	public function get_keywords(): array
    {
		return [ 'image', 'hover', 'hover-content' ];
	}

	public function get_categories(): array
    {
		return [ 'spider-element-pro' ];
	}

	/**
	 * Name: get_style_depends()
	 * Desc: Register the required CSS dependencies for the frontend.
	 */
	public function get_style_depends(): array
    {
		return [ 'spel-main', 'spel-main-pro' ];
	}

	protected function register_controls(): void
    {
		$this->elementor_content_control();
		$this->elementor_style_control();
	}

	protected function elementor_content_control(): void
    {

        //===================== Select Preset ===========================//
		$this->start_controls_section(
			'style_sec',
			[
				'label' => esc_html__( 'Preset Skins', 'spider-elements-pro' ),
			]
		);

		$this->add_control(
			'style',
			[
				'label'   => esc_html__( 'Style', 'spider-elements-pro' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'1' => [
						'icon'  => 'img_hover1',
						'title' => esc_html__( '01 : Hover Image with content', 'spider-elements-pro' )
					],
					'2' => [
						'icon'  => 'img_hover2',
						'title' => esc_html__( '02 : Hover Image with content', 'spider-elements-pro' ),
					],
					'3' => [
						'icon'  => 'img_hover3',
						'title' => esc_html__( '03 : Hover Image with content', 'spider-elements-pro' ),
					],
					'4' => [
						'icon'  => 'img_hover4',
						'title' => esc_html__( '04 : Hover Image with content', 'spider-elements-pro' ),
					],
				],
				'default' => '1',
			]
		);

		$this->end_controls_section(); //End Select Style

		$this->start_controls_section(
			'section_image',
			[
				'label' => esc_html__( 'Image', 'spider-elements-pro' ),
			]
		);

		$this->add_control(
			'hover_image',
			[
				'label'   => esc_html__( 'Choose Image', 'spider-elements-pro' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
			]
		);

		$this->add_control(
			'img_hover4_link', [
				'label'   => esc_html__( 'Link', 'spider-elements-pro' ),
				'type'    => Controls_Manager::URL,
				'default' => [
					'url' => '#',
				],
				'condition'   => [
					'style'  => [ '4' ],
				],
			]
		);

		$this->end_controls_section();
	}

	public function elementor_style_control() {

		//============================ Tab Style ============================//
		$this->start_controls_section(
			'style_img_hover_sec',
			[
				'label'     => esc_html__( 'Image Box', 'spider-elements-pro' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'style' => [ '1', '2' ]
				]
			]
		);

		$this->add_control(
			'style_img_hover_bg',
			[
				'label'     => esc_html__( 'Overlay Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .spel_image_hover,{{WRAPPER}} .style_three,{{WRAPPER}} .style_three .back' => 'background: {{VALUE}};',
				),
			]
		);

		$this->end_controls_tab(); // End Active Tab
		$this->end_controls_section();

		$this->start_controls_section(
			'style_img_hover_content',
			[
				'label'     => esc_html__( 'Hover Contents', 'spider-elements-pro' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'style' => [ '1', '2', '3' ]
				]
			]
		);

		$this->add_control(
			'hover_title',
			[
				'label' => esc_html__( 'Title', 'spider-elements-pro' ),
				'type'  => Controls_Manager::HEADING
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'hover_title_typo',
				'label'    => esc_html__( 'Typography', 'spider-elements-pro' ),
				'selector' => '{{WRAPPER}} .spel_image_hover figcaption h3,{{WRAPPER}} .style_three .text h3',
			]
		);

		$this->add_control(
			'hover_title_color',
			[
				'label'     => esc_html__( 'Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .spel_image_hover figcaption h3,{{WRAPPER}} .style_three .text h3' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'hover_title_margin',
			[
				'label'      => esc_html__( 'Margin', 'spider-elements-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .spel_image_hover figcaption h3,{{WRAPPER}} .style_three .text h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'default'    => [
					'unit' => 'px', // The selected CSS Unit. 'px', '%', 'em',
				],
			]
		);

		$this->add_control(
			'hover_desc',
			[
				'label'     => esc_html__( 'Caption', 'spider-elements-pro' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'hover_caption_typo',
				'label'    => esc_html__( 'Typography', 'spider-elements-pro' ),
				'selector' => '{{WRAPPER}} .spel_image_hover figcaption p,{{WRAPPER}} .style_three .text p',
			]
		);

		$this->add_control(
			'hover_caption_color',
			[
				'label'     => esc_html__( 'Text Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .spel_image_hover figcaption p,{{WRAPPER}} .style_three .text p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name'     => 'background',
				'type'     => [ 'classic', 'gradient' ],
				'exclude'  => [ 'image' ],
				'selector' => '{{WRAPPER}} .spel_image_hover figcaption:before,
							   {{WRAPPER}}.spel_image_hover,{{WRAPPER}} .style_three,{{WRAPPER}} .style_three .back',
			]
		);

		$this->end_controls_tab(); // End Active Tab

		$this->end_controls_section(); // End Tab Style
	}

	/**
	 * Render alert widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		extract( $settings ); // extract all settings array to variables converted to name of key

		$image_id = ! empty( $settings['hover_image']['id'] ) ? $settings['hover_image']['id'] : '';

		$img_attachment_meta = spel_el_image_caption( $image_id );

		//================= Template Parts =================//
		include "templates/image-hover/image-hover-{$settings['style']}.php";
	}
}