<?php

/**
 * Plugin Name: Spider Elements Pro
 * Requires Plugins: elementor, spider-elements
 * Plugin URI: https://spider-themes.net/
 * Description: Spider Elements Pro sample asset for elementor widgets.
 * Version: 1.2.1

 * Update URI: https://api.freemius.com
 * Requires at least: 5.0
 * Tested up to: 6.8
 * Requires PHP: 7.4
 * Author: spider-themes
 * Author URI: https://spider-themes.net/
 * Text domain: spider-elements-pro
 * Domain Path: /languages
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */
if ( !defined( 'ABSPATH' ) ) {
    exit;
}
if ( function_exists( 'spel_fs' ) ) {
    spel_fs()->set_basename( true, __FILE__ );
} else {
    // DO NOT REMOVE THIS IF; IT IS ESSENTIAL FOR THE `function_exists` CALL ABOVE TO PROPERLY WORK.
    if ( !function_exists( 'spel_fs' ) ) {
        // Create a helper function for easy SDK access.
        function spel_fs() {
            global $spel_fs;
            if ( !isset( $spel_fs ) ) {
                // Include Freemius SDK.
                require_once dirname( __FILE__ ) . '/includes/freemius/start.php';
                $spel_fs = fs_dynamic_init( [
                    'id'             => '16034',
                    'slug'           => 'spider-elements',
                    'premium_slug'   => 'spider-elements-pro',
                    'type'           => 'plugin',
                    'public_key'     => 'pk_711f20dd503c8eb713171079ffeb5',
                    'is_premium'     => true,
                    'premium_suffix' => 'pro',
                    'has_addons'     => false,
                    'has_paid_plans' => true,
                    'trial'          => [
                        'days'               => 14,
                        'is_require_payment' => true,
                    ],
                    'menu'           => [
                        'slug'       => 'spider_elements_settings',
                        'contact'    => true,
                        'support'    => true,
                        'first-path' => 'admin.php?page=spider_elements_settings',
                    ],
                    'is_live'        => true,
                ] );
            }
            return $spel_fs;
        }

        // Init Freemius.
        spel_fs()->add_filter( 'deactivate_on_activation', '__return_false' );
        spel_fs()->add_filter( 'hide_freemius_powered_by', '__return_true' );
        // Init Freemius.
        spel_fs();
        // Signal that SDK was initiated.
        do_action( 'spel_fs_loaded' );
    }
}
/**
 * SPEL_PRO class.
 *
 * The main class that initiates and runs the addon.
 *
 * @since 1.0.0
 */
if ( !class_exists( 'SPEL_PRO' ) ) {
    /**
     * Class SPEL_PRO
     */
    class SPEL_PRO {
        /**
         * Plugin Version
         *
         * Holds the version of the plugin.
         *
         * @since 1.0.0
         * @var string The plugin version.
         */
        const VERSION = '1.2.1';

        /**
         * Instance
         *
         * Holds a single instance of the `Listy_Core` class.
         *
         * @since  1.7.0
         *
         * @access private
         * @static
         *
         * @var SPEL_PRO A single instance of the class.
         */
        private static $_instance = null;

        /**
         * Instance
         *
         * Ensures only one instance of the class is loaded or can be loaded.
         *
         * @return SPEL_PRO An instance of the class.
         * @since  1.7.0
         *
         * @access public
         * @static
         *
         */
        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }
            return self::$_instance;
        }

        /**
         * Clone
         *
         * Disable class cloning.
         *
         * @return void
         * @since  1.7.0
         *
         * @access protected
         *
         */
        public function __clone() {
            // Cloning instances of the class is forbidden
            _doing_it_wrong( __FUNCTION__, esc_html__( 'Cheatin&#8217; huh?', 'spider-elements-pro' ), '1.0.0' );
        }

        /**
         * Wakeup
         *
         * Disable un-serializing the class.
         *
         * @return void
         * @since  1.7.0
         *
         * @access protected
         *
         */
        public function __wakeup() {
            // Un-Serializing instances of the class is forbidden.
            _doing_it_wrong( __FUNCTION__, esc_html__( 'Cheatin&#8217; huh?', 'spider-elements-pro' ), '1.7.0' );
        }

        /**
         * Constructor
         *
         * Initialize the Listy Core plugins.
         *
         * @since  1.7.0
         *
         * @access public
         */
        public function __construct() {
            // Include Files
            $this->core_includes();
            // define constants
            $this->define_constants();
            add_action( 'init', [$this, 'i18n'] );
            add_action( 'plugins_loaded', [$this, 'init_plugin'] );
            // Register Category
            add_action( 'elementor/elements/categories_registered', [$this, 'elements_register_category'] );
            // Register widgets
            add_action( 'elementor/widgets/register', [$this, 'on_widgets_registered'] );
        }

        /**
         * Load Textdomain
         *
         * Load plugin localization files.
         *
         * @since  1.7.0
         *
         * @access public
         */
        public function i18n() : void {
            load_plugin_textdomain( 'spider-elements-pro', false, plugin_basename( dirname( __FILE__ ) ) . '/languages' );
        }

        /**
         * Include Files
         *
         * Load core files required to run the plugin.
         *
         * @since  1.7.0
         *
         * @access public
         */
        public function core_includes() : void {
            // Fronted UI
            require_once __DIR__ . '/includes/Frontend/Assets.php';
            // Features List
            require_once __DIR__ . '/includes/Admin/extension/Features_Box.php';
            require_once __DIR__ . '/includes/Admin/extension/Reveal_Animation.php';
        }

        public function init_plugin() : void {
            // Features List
            $feature_opt = get_option( 'spel_features_settings' );
            if ( isset( $feature_opt['spel_reveal_animation'] ) && $feature_opt['spel_reveal_animation'] == 'on' ) {
                new SPEL_PRO\includes\Admin\extension\Reveal_Animation();
            }
            if ( isset( $feature_opt['spel_feature_box'] ) && $feature_opt['spel_feature_box'] == 'on' ) {
                new SPEL_PRO\includes\Admin\extension\Features_Box();
            }
            // Frontend UI
            new SPEL_PRO\includes\Frontend\Assets();
        }

        /**
         * Add new Elementor Categories
         *
         * Register new widget categories for Listy Core widgets.
         *
         * @since  1.0.0
         * @since  1.7.1 The method moved to this class.
         *
         * @access public
         */
        public function elements_register_category() : void {
            \Elementor\Plugin::instance()->elements_manager->add_category( 'spider-element-pro', [
                'title' => esc_html__( 'Spider Elements Pro', 'spider-elements-pro' ),
            ], 1 );
        }

        /**
         * Register New Widgets
         *
         * Include Listy Core widgets files and register them in Elementor.
         *
         * @since  1.0.0
         * @since  1.7.1 The method moved to this class.
         *
         * @access public
         */
        public function on_widgets_registered() : void {
            $this->include_widgets();
            $this->register_widgets();
        }

        /**
         * Include Widgets files
         *
         * Load widget files
         *
         * @since  1.2.0
         * @access private
         */
        private function include_widgets() : void {
            require_once __DIR__ . '/widgets/Accordion_Article.php';
            require_once __DIR__ . '/widgets/Box_Hover.php';
            require_once __DIR__ . '/widgets/Feature_Box.php';
            require_once __DIR__ . '/widgets/Flip_Box.php';
            require_once __DIR__ . '/widgets/Hotspot.php';
            require_once __DIR__ . '/widgets/Image_Hover.php';
            require_once __DIR__ . '/widgets/Image_Slides.php';
            require_once __DIR__ . '/widgets/Marquee_Slider.php';
            require_once __DIR__ . '/widgets/Skill_Showcase.php';
            require_once __DIR__ . '/widgets/Stacked_Image.php';
        }

        /**
         * Register Widgets
         *
         * Register new Elementor widgets.
         *
         * @since  1.0.0
         * @since  1.7.1 The method moved to this class.
         *
         * @access private
         */
        private function register_widgets() : void {
            // Register each widget class
            $widgets_manager = \Elementor\Plugin::instance()->widgets_manager;
            $elements_opt = get_option( 'spe_widget_settings' );
            $widgets = [
                'spel_accordion_article'    => 'Accordion_Article',
                'docy_box_hover'            => 'Box_Hover',
                'spe_feature_box'           => 'Feature_Box',
                'docy_flip_box'             => 'Flip_Box',
                'docly_hotspot'             => 'Hotspot',
                'docy_image_hover'          => 'Image_Hover',
                'docy_image_slides'         => 'Image_Slides',
                'spel_marquee_slider'       => 'Marquee_Slider',
                'spe_skill_showcase_widget' => 'Skill_Showcase',
                'spel_stacked_image'        => 'Stacked_Image',
            ];
            foreach ( $widgets as $option_key => $class_name ) {
                if ( isset( $elements_opt[$option_key] ) && $elements_opt[$option_key] === 'on' ) {
                    $class = "\\SPEL_PRO\\Widgets\\{$class_name}";
                    $widgets_manager->register( new $class() );
                }
            }
        }

        /**
         * @return void
         * @since  1.7.0
         * @access public
         * @static
         */
        public function define_constants() : void {
            //SPF(Short form - Spider Elements)
            define( 'SPEL_PRO_VERSION', self::VERSION );
            define( 'SPEL_PRO_FILE', __FILE__ );
            define( 'SPEL_PRO_PATH', __DIR__ );
            define( 'SPEL_PRO_URL', plugins_url( '', SPEL_PRO_FILE ) );
            define( 'SPEL_PRO_ASSETS', SPEL_PRO_URL . '/assets' );
            define( 'SPEL_PRO_CSS', SPEL_PRO_URL . '/assets/css' );
            define( 'SPEL_PRO_JS', SPEL_PRO_URL . '/assets/js' );
            define( 'SPEL_PRO_IMG', SPEL_PRO_URL . '/assets/images' );
            define( 'SPEL_PRO_VEND', SPEL_PRO_URL . '/assets/vendors' );
        }

    }

}
/**
 * Initialize the main plugin class
 *
 * @return \SPEL_PRO
 *
 */
if ( !function_exists( 'spel_pro' ) ) {
    function spel_pro() {
        return SPEL_PRO::instance();
    }

    //kick-off the plugin
    spel_pro();
}