<?php
namespace SPEL_PRO\includes\Frontend;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * Assets Class
 */
class Assets {

	public function __construct() {

        // Register Widget Style's
        add_action('elementor/frontend/after_enqueue_styles', [$this, 'register_widget_styles']);

        // Register Widget Script's
        add_action('elementor/editor/after_enqueue_scripts', [$this, 'register_widget_scripts']);
        add_action('elementor/frontend/after_register_scripts', [$this, 'register_widget_scripts']);

        // Register Elementor Preview Editor Script's
        add_action('elementor/editor/after_enqueue_scripts', [$this, 'register_editor_scripts']);
        add_action('elementor/frontend/after_enqueue_scripts', [$this, 'register_editor_scripts']);

	}


	/**
	 * Register Widget Scripts
	 *
	 * Register custom style required to run Spider Elements.
	 *
	 * @access public
	 */
	function register_widget_styles(): void
    {

        $features_opt   = get_option( 'spel_features_settings' );
        $features_box = isset($features_opt['spel_feature_box']) && $features_opt[ 'spel_feature_box' ] == 'on' ?? '';
        $reveal_animation = isset($features_opt['spel_reveal_animation']) && $features_opt[ 'spel_reveal_animation' ] == 'on' ?? '';

        if ( $features_box || $reveal_animation ) {
            wp_enqueue_style( 'spel-pro-extension' );
        }

        wp_register_style('spel-pro-extension', SPEL_PRO_CSS . '/extension.css');
		wp_register_style( 'spel-main-pro', SPEL_PRO_CSS . '/main.css' );

	}


    /**
     * Register Widget Scripts
     *
     * Register custom scripts required to run Spider Elements.
     *
     * @access public
     */
    function register_widget_scripts(): void
    {

        $features_opt   = get_option( 'spel_features_settings' );
        if ( isset($features_opt['spel_feature_box']) && $features_opt[ 'spel_feature_box' ] == 'on' ) {
            wp_enqueue_script( 'spel-pro-features-box' );
        }

        if ( isset($features_opt['spel_reveal_animation']) && $features_opt[ 'spel_reveal_animation' ] == 'on' ) {
            wp_enqueue_script( 'gsap' );
            wp_enqueue_script( 'ScrollTrigger' );
            wp_enqueue_script( 'spel-pro-reveal-anim' );
        }

        wp_register_script('spel-pro-features-box', SPEL_PRO_JS . '/extension/features-box.js', [ 'jquery' ], SPEL_PRO_VERSION, ['strategy' => 'defer']);
        wp_register_script( 'gsap', SPEL_PRO_VEND . '/animation/gsap.min.js', ['jquery'], '3.12.0', ['strategy' => 'defer'] );
        wp_register_script( 'ScrollTrigger', SPEL_PRO_VEND . '/animation/scroll-trigger.min.js', ['jquery'], '3.12.0', ['strategy' => 'defer'] );
        wp_register_script( 'spel-pro-reveal-anim', SPEL_PRO_JS . '/extension/reveal-anim.js', [ 'jquery', 'gsap', 'ScrollTrigger' ], SPEL_PRO_VERSION, ['strategy' => 'defer'] );

    }


	/**
	 * Register Widget Styles
	 *
	 * Register custom styles required to run Spider Elements.
	 *
	 * @access public
	 */
	function register_editor_scripts(): void
    {
		wp_register_script( 'spel-el-pro-widgets', SPEL_PRO_JS . '/elementor-widgets.js', ['jquery', 'elementor-frontend'], SPEL_PRO_VERSION, ['strategy' => 'defer'] );
	}

}