<?php
namespace Elementor;
namespace SPEL_PRO\includes\Admin\extension;

use Elementor\Controls_Manager;
use Elementor\Element_Base;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class Reveal_Animation {

	public function __construct() {

		// Elementor Heading, Text Editor Widget Support
		add_action( 'elementor/element/heading/section_title_style/after_section_end', [ $this, 'register_section_controls' ] );
		add_action( 'elementor/element/text-editor/section_editor/after_section_end', [ $this, 'register_section_controls' ] );

		// Add the 'before_render' action hook to the widget
		add_action( 'elementor/editor/before_render', [ $this, 'callback_render_display_content' ], 99 );
		add_action( 'elementor/frontend/before_render', [ $this, 'callback_render_display_content' ], 99 );

	}


	public function callback_render_display_content( Element_Base $element): void
    {

		$spe_reveal_anim_enable = $element->get_settings_for_display( 'spe_reveal_anim_enable' );
		$spe_highlighted_text_enable = $element->get_settings_for_display( 'spe_highlighted_text_enable' );

		if ( 'yes' === $spe_reveal_anim_enable ) {
			$element->add_render_attribute( '_wrapper', 'class', 'spe-reveal-anim-text' );
		}

		if ( 'yes' === $spe_highlighted_text_enable ) {
			$element->add_render_attribute( '_wrapper', 'class', 'spe-reveal-text' );
		}

	}

	public function register_section_controls( Element_Base $element): void
    {

		//=============== Start Reveal Animation ===============//
		$element->start_controls_section(
			'spe_reveal_anim_sec', [
				'label' => esc_html__( 'Reveal Animation', 'spider-elements-pro' ) . SPEL_TEXT_BADGE,
			]
		);

		$element->add_control(
			'spe_reveal_anim_enable', [
				'type'               => \Elementor\Controls_Manager::SWITCHER,
				'label'              => esc_html__( 'Enable Animation', 'spider-elements-pro' ),
				'frontend_available' => true,
				'return_value'       => 'yes',
				'default'            => 'no',
			]
		);

		$element->end_controls_section(); // End Section

	}


}