<?php
namespace Elementor;
namespace SPEL_PRO\includes\Admin\extension;

use Elementor\Controls_Manager;
use Elementor\Element_Base;
use Elementor\Group_Control_Background;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * Register Advance Features Control Tab
 * Container & Section Features
 */
class Features_Box {

    public function __construct ()
    {

        // Section Elements Fields
        add_action('elementor/element/section/section_advanced/after_section_end', [ $this, 'register_section_controls' ]);
        add_action('elementor/element/column/section_advanced/after_section_end', [ $this, 'register_section_controls' ]);
        add_action('elementor/element/container/section_layout/after_section_end', [ $this, 'register_section_controls' ]);

        // Add the 'before_render' action hook to the widget
        add_action('elementor/editor/before_render', [ $this, 'callback_render_display_content' ], 10, 1);
        add_action('elementor/frontend/before_render', [ $this, 'callback_render_display_content' ], 10, 1);

    }


    /**
     * Section Controls
     */
    public function register_section_controls (Element_Base $element): void
    {

        //=============== Start Features Box ===============//
        $element->start_controls_section(
            'spel_features_box_sec', [
                'label' => esc_html__('Features Box', 'spider-elements-pro'),
                'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );

        $element->add_control(
            'spe_features_box_enable', [
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label' => esc_html__('Enable Section', 'spider-elements-pro'),
                'frontend_available' => true,
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        //============= Start Icon Settings =============//
        $element->add_control(
            'spe_fb_icon', [
                'label' => esc_html__('Icon', 'spider-elements-pro'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'condition' => [
                    'spe_features_box_enable' => 'yes',
                ],
            ]
        );

        $element->start_controls_tabs(
            'spe_fb_icon_tabs'
        );

        $element->start_controls_tab(
            'spe_fb_icon_normal_tab', [
                'label' => esc_html__('Normal', 'spider-elements-pro'),
                'condition' => [
                    'spe_features_box_enable' => 'yes',
                ],
            ]
        );

        $element->add_group_control(
            Group_Control_Background::get_type(), [
                'name' => 'title_normal_bg_color',
                'types' => [ 'classic', 'gradient' ],
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .wrapper_icon',
                'condition' => [
                    'spe_features_box_enable' => 'yes',
                ],
            ]
        );

        $element->add_control(
            'spe_fb_icon_normal_color',
            [
                'label' => esc_html__('Icon Color', 'spider-elements-pro'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .wrapper_icon' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'spe_features_box_enable' => 'yes',
                ],
            ]
        );

        $element->end_controls_tab();

        $element->start_controls_tab(
            'spe_fb_icon_hover_tab',
            [
                'label' => esc_html__('Hover', 'spider-elements-pro'),
                'condition' => [
                    'spe_features_box_enable' => 'yes',
                ],
            ]
        );

        $element->add_group_control(
            Group_Control_Background::get_type(), [
                'name' => 'title_hover_bg_color',
                'types' => [ 'classic', 'gradient' ],
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}}.spe-features-box-enable:hover .wrapper_icon',
                'condition' => [
                    'spe_features_box_enable' => 'yes',
                ],
            ]
        );

        $element->add_control(
            'spe_fb_icon_hover_color',
            [
                'label' => esc_html__('Icon Color', 'spider-elements-pro'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}.spe-features-box-enable:hover .wrapper_icon' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'spe_features_box_enable' => 'yes',
                ],
            ]
        );

        $element->end_controls_tab();
        $element->end_controls_tabs(); //End Icon Settings

        $element->add_control(
            'spe_fb_icon_size', [
                'label' => esc_html__('Icon Font Size', 'spider-elements-pro'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors' => [
                    '{{WRAPPER}} .wrapper_icon' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'spe_features_box_enable' => 'yes',
                ],
                'separator' => 'before',
            ]
        ); //End Icon Settings

        $element->add_control(
            'spe_fb_icon_width', [
                'label' => __('Icon Box Width', 'spider-elements-pro'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => '',
                    'unit' => 'px',
                ],
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .wrapper_icon' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'spe_features_box_enable' => 'yes',
                ],
            ]
        );

        // Wrapper Link
        $element->add_control(
            'spe_fb_wrapper_link', [
                'label' => __('Wrapper Link', 'spider-elements-pro'),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => 'https://example.com',
                'condition' => [
                    'spe_features_box_enable' => 'yes',
                ],
            ]
        );

        $element->end_controls_section(); // End Section

    }


    /**
     * @param Element_Base $element
     *
     * @return void
     */
    public function callback_render_display_content (Element_Base $element): void
    {

        $wrapper_link = $element->get_settings_for_display('spe_fb_wrapper_link');
        $feature_icon = $element->get_settings_for_display('spe_fb_icon');

        // It's render elementor wrapper div - Icon
        if ($feature_icon && !empty($feature_icon[ 'value' ])) {

            //It's render elementor wrapper div
            $element->add_render_attribute(
                '_wrapper', [
                    'class' => 'spe-features-box-enable',
                    'data-spe-element-icon' => $feature_icon[ 'value' ],
                ]
            );

        }

        // It's render elementor wrapper div - Link
        if ($wrapper_link && !empty($wrapper_link[ 'url' ])) {
            $element->add_render_attribute(
                '_wrapper', [
                    'data-spe-element-link' => json_encode($wrapper_link),
                    'style' => 'cursor: pointer'
                ]
            );

        }

    }


}