<div class="video_slider_area video-playlist">
    <div class="gallery-top">
        <?php
        while ( $videos->have_posts() ) : $videos->the_post();
            $video = function_exists('docy_meta') ? docy_meta('video') : '';
            ?>
            <div class="item">
                <div class="row">
                    <div class="col-lg-7">
                        <video id="player_<?php the_ID(); ?>" class="video-js vjs-fluid vjs-default-skin" controls preload playsinline poster="<?php echo get_the_post_thumbnail_url(get_the_ID(), 'docy_671x411') ?>">
                            <?php if ( !empty( $video ) ) :  ?>
                                <source src="<?php echo esc_url($video);  ?>" type="video/mp4">
                            <?php endif; ?>
                        </video>
                    </div>
                    <div class="col-lg-5">
                        <div class="slide_text">
                            <a href="#">
                                <?php the_title('<h4>', '</h4>'); ?>
                            </a>
                            <?php the_excerpt(); ?>
                            <div class="video_user">
                                <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ) ?>">
                                    <i class="fa fa-user"></i><?php the_author_meta('display_name'); ?>
                                </a>
                                <a href="<?php docycore_day_link( get_the_id() ); ?>">
                                    <i class="fa fa-calendar"></i> <?php the_time(get_option('date_format')); ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php
        endwhile;
        wp_reset_postdata();
        ?>
    </div>

    <div class="gallery_main_area">
        <div class="gallery-thumbs">
            <?php
            while ( $videos->have_posts() ) : $videos->the_post();
                ?>
                <div class="item">
                    <div class="gallery_inner_thumb">
                        <?php the_post_thumbnail('docy_270x152'); ?>
                        <div class="caption_text">
                            <div class="play-icon">
                                <i class="fa fa-play"></i>
                            </div>
                            <?php the_title('<h4>', '</h4>') ?>
                        </div>
                    </div>
                </div>
                <?php
            endwhile;
            wp_reset_postdata();
            ?>
        </div>
        <div class="prev">
            <i class="fa fa-chevron-left"></i>
        </div>
        <div class="next">
            <i class="fa fa-chevron-right"></i>
        </div>
    </div>
</div>

<script>
    ;(function ($) {

        "use strict";

        $(document).ready(function () {
            $(".gallery-top")
                .slick({
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    arrows: false,
                    fade: true,
                    infinite: false,
                    asNavFor: ".gallery-thumbs",
                })
                .on("beforeChange", function (event, slick, currentSlide, nextSlide) {
                    $(".gallery-top .slick-current video").attr(
                        "src",
                        $(".gallery-top .slick-current video").attr("src")
                    );
                    $(".gallery-top .slick-current .video-js").removeClass("vjs-playing");
                });
            $(".gallery-thumbs")
                .slick({
                    slidesToShow: 4,
                    slidesToScroll: 1,
                    vertical: false,
                    asNavFor: ".gallery-top",
                    dots: false,
                    focusOnSelect: true,
                    arrows: true,
                    infinite: false,
                    swipeToSlide: true,
                    prevArrow: $(".prev"),
                    nextArrow: $(".next"),
                    responsive: [
                        {
                            breakpoint: 992,
                            settings: {
                                vertical: false,
                                slidesToShow: 3,
                            },
                        },
                        {
                            breakpoint: 768,
                            settings: {
                                vertical: false,
                                slidesToShow: 3,
                            },
                        },
                        {
                            breakpoint: 650,
                            settings: {
                                vertical: false,
                                slidesToShow: 2,
                            },
                        },
                        {
                            breakpoint: 480,
                            settings: {
                                vertical: false,
                                slidesToShow: 1,
                            },
                        },
                    ],
                })
                .on("beforeChange", function (event, slick, currentSlide, nextSlide) {
                    $(".gallery-thumbs .slick-current video").attr(
                        "src",
                        $(".gallery-thumbs .slick-current video").attr("src")
                    );
                    $(".gallery-thumbs .slick-current .video-js").removeClass(
                        "vjs-playing"
                    );
                });

            function Video_slide_player() {
                const myPlayers = Array(
                    <?php while ( $videos->have_posts() ) : $videos->the_post(); ?>
                    videojs("player_<?php echo esc_js(get_the_ID()); ?>"),
                    <?php endwhile; wp_reset_postdata(); ?>
                );
            }
            Video_slide_player();
        })

    })(jQuery);
</script>