<?php
namespace DocyCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use WP_Query;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Class Faq
 * @package DocyCore\Widgets
 */
class Faq extends Widget_Base {
    public function get_name() {
        return 'docy_faq';
    }

    public function get_title() {
        return esc_html__( 'FAQ Tabs', 'docy-core' );
    }

    public function get_icon() {
        return 'eicon-menu-bar';
    }

    public function get_categories() {
        return [ 'docy-elements' ];
    }

    public function get_keywords() {
        return [ 'frequently asked questions', 'docy', 'tabs', 'faqs' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'style_sec',
            [
                'label' => esc_html__( 'Preset Skins', 'docy-core' ),
            ]
        );

        $this->add_control(
            'style', [
                'label'     => esc_html__( 'Skin', 'docy-core' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    '1' => [
                        'title' => __( 'Top - Tabbed', 'coro-core' ),
                        'icon'  => 'faq1',
                    ],
                    '2' => [
                        'title' => __( 'Left Side - Box Tabbed', 'coro-core' ),
                        'icon'  => 'faq2',
                    ],
                    '3' => [
                        'title' => __( 'Left Side - Tag Style Tab', 'coro-core' ),
                        'icon'  => 'faq3',
                    ],
                ],
                'toggle'    => false,
                'default'   => '1',
            ]
        );

        $this->add_control(
            'nav_title',
            [
                'label'         => esc_html__( 'Navigation Title', 'docy-core' ),
                'type'          => Controls_Manager::TEXT,
                'label_block'   => true,
                'default'       => 'Quick Navigation',
                'condition'     => [
                    'style'     => ['2', '3']
                ]
            ]
        );

        $this->end_controls_section();

        // ---------------------------------- Filter Options ------------------------
        $this->start_controls_section(
            'filter', [
                'label' => esc_html__( 'Filter Options', 'docy-core' ),
            ]
        );

        $this->add_control(
            'cat_number', [
                'label'     => esc_html__( 'Category Number', 'docy-core' ),
                'type'      => Controls_Manager::TEXT,
                'default'   => '6'
            ]
        );

        $this->add_control(
            'order_cat', [
                'label'     => esc_html__( 'Category Order', 'docy-core' ),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    'ASC'   => 'ASC',
                    'DESC'  => 'DESC'
                ],
                'default'   => 'ASC'
            ]
        );

        $this->add_control(
            'orderby_cat', [
                'label'     => esc_html__( 'Category Order by', 'docy-core' ),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    'name'  => 'Name',
                    'slug'  => 'Slug',
                    'count' => 'Count',
                    'none'  => 'None',
                ],
                'default'   => 'name'
            ]
        );

        $this->add_control(
            'order', [
                'label'     => esc_html__( 'Order', 'docy-core' ),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    'ASC'   => 'ASC',
                    'DESC'  => 'DESC'
                ],
                'default'   => 'ASC'
            ]
        );

        $this->add_control(
            'exclude_cat', [
                'label'    => esc_html__( 'Exclude Post', 'docy-core' ),
                'type'     => Controls_Manager::SELECT2,
                'options'  => docy_get_faq_categories(),
                'multiple' => true
            ]
        );

        $this->end_controls_section();

        /******************* Style Tab****************** */
        $this->start_controls_section(
			'tab_style',
			[
				'label' => esc_html__( 'Tabs', 'docy-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

        /*********************** Tabs *********************/
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'      => 'content_typography_tabs',
				'selector'  => '{{WRAPPER}} .nav-link',
			]
		);
        $this->start_controls_tabs(
			'style_tabs'
		);

		$this->start_controls_tab(
			'style_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'docy-core' ),
			]
		);
           
        $this->add_control(
			'text_color',
			[
				'label'     => esc_html__( 'Text Color', 'docy-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .nav-link' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name'              => 'content_background',
                'label'             => esc_html__( 'Background', 'docy-core' ),
				'types'             => [ 'classic','gradient'],
				'selector'          => '{{WRAPPER}} .doc_tag .nav-item .nav-link',
                'exclude'           => ['image'],
                'fields_options'    => [
                    'background'    => [
                        'label'     => esc_html__('Background', 'docy-core'),
                        'default'   => 'classic',
                    ],
                    'color' => [
                        'default' => '',
                    ],
                ],
				'condition'     => [
					'style'     => '1',
				]
			]
		);

        $this->add_control(
			'hr',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
                      
        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'      => 'border',
				'selector'  => '{{WRAPPER}} .doc_tag .nav-item .nav-link',
				'condition'     => [
					'style'     => '1',
				]
			]
		);
        $this->add_control(
			'separetor',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

        /******************** gpa between tab and content **************/
        $this->add_control(
			'bottom_gap',
			[
				'label'         => esc_html__( 'Bottom Gap', 'docy-core' ),
                'description'   => esc_html__('Gap between Tabs and Content'),
				'type'          => \Elementor\Controls_Manager::SLIDER,
               
				'size_units'    => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range'         => [
					'px'   => [
						'min'   => 0,
						'max'   => 1000,
						'step'  => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default'   => [
					'unit'  => '',
					'size'  => '',
				],
				'condition'     => [
					'style'     => '1',
				],
				'selectors' => [
					'{{WRAPPER}} .doc_faq_area .doc_tag' => 'margin-bottom: {{SIZE}}{{UNIT}} !important;',
				],
                'label_block' => true,
			]
		);
        

		$this->end_controls_tab();
        
        /************************ tab active ******************** */
		$this->start_controls_tab(
			'style_active_tab',
			[
				'label' => esc_html__( 'Active', 'docy-core' ),
			]
		);

		$this->add_control(
			'active_color',
			[
				'label'     => esc_html__( 'Text Color', 'docy-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .nav-item .nav-link.active' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name'              => 'background',
                'label'             => esc_html__( 'Background', 'docy-core' ),
				'types'             => [ 'classic','gradient'],
				'selector'          => '{{WRAPPER}} .doc_tag .nav-item .nav-link.active',
                'exclude'           => ['image'],
                'fields_options'    => [
                    'background'    => [
                        'label'     => esc_html__('Background', 'docy-core'),
                        'default'   => 'classic',
                    ],
                ],
				'condition'     => [
					'style'     => '1',
				]
			]
		);
    
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'      => 'content_typography',
				'selector'  => '{{WRAPPER}} .nav-link',
			]
		);
              
        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'      => 'border1',
				'selector'  => '{{WRAPPER}} .doc_tag .nav-item .nav-link',
			]
		);
		$this->end_controls_tab();

		$this->end_controls_tabs();

        $this->end_controls_section();
        // end style 

    }

    protected function render() {
        $settings           = $this->get_settings();

        $cats = get_terms( array (
            'taxonomy'      => 'faq_cat',
            'hide_empty'    => true,
            'orderby'       => $settings['orderby_cat'] ?? 'name',
            'order'         => $settings['order_cat'] ?? 'ASC',
            'number'        => $settings['cat_number'] ?? 6,
            'exclude'       => $settings['exclude_cat'] ?? '',
        ));

        include( "inc/faqs/faq-{$settings['style']}.php" );
    }

}