<?php
/**
 * Use namespace to avoid conflict
 */
namespace DocyCore\widgets\ElementorAdvance;

use Elementor\Controls_Stack;

/**
 * Elementor Advance Section
 *
 * @package Docy_Core
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Class Advance_Section
 * @package DocyCore\widgets\ElementorAdvance\Controls
 */
class Advance_Section {

    /**
     * Advance_Section constructor.
     */
    function __construct() {
        add_action( 'plugins_loaded', array( $this, 'register_advance_control_tab' ) );
    }

    /**
     * Register Advance Control Tab
     */
    function register_advance_control_tab() {

        // Section & Widget Element Support
        add_action( 'elementor/element/after_section_end', [ $this, 'dark_mode_control' ], 10, 2);

        // Flexbox Container Support
        add_action( 'elementor/element/container/section_background/after_section_end', [ $this, 'dark_mode_control' ], 10, 2);

    }

    /**
     * Add Dark Mode Controls to Elementor Elements
     *
     * @param Controls_Stack $element    The element stack.
     * @param mixed          $section_id Section ID or args.
     */
    function dark_mode_control ( Controls_Stack $element, $section_id ) {
        // Handle section_id in different formats
        $section_id_value = '';

        if (is_string($section_id)) {
            $section_id_value = $section_id;
        } elseif (is_array($section_id) && isset($section_id['section'])) {
            $section_id_value = $section_id['section'];
        } elseif (is_object($section_id) && method_exists($section_id, 'get_id')) {
            $section_id_value = $section_id->get_id();
        }

        $element_section = 'section' === $element->get_name() && 'section_background' === $section_id_value;
        $element_container = 'container' === $element->get_name() && 'section_background' === $section_id_value;

        if ( $element_section || $element_container ) {

            // Start Dark Mode Settings Section
            $element->start_controls_section(
                'dark_mode_sec',
                [
                    'label' => __( 'Dark Mode Color', 'docy-core' ),
                    'tab' => \Elementor\Controls_Manager::TAB_ADVANCED,
                ]
            );

            $element->add_control(
                'dark_mode_text_color', [
                    'label' => esc_html__( 'Text Color', 'docy-core' ),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        // Headings
                        '.body_dark {{WRAPPER}} h1' => 'color: {{VALUE}} !important;',
                        '.body_dark {{WRAPPER}} h2' => 'color: {{VALUE}} !important;',
                        '.body_dark {{WRAPPER}} h3' => 'color: {{VALUE}} !important;',
                        '.body_dark {{WRAPPER}} h4' => 'color: {{VALUE}} !important;',
                        '.body_dark {{WRAPPER}} h5' => 'color: {{VALUE}} !important;',
                        '.body_dark {{WRAPPER}} h6' => 'color: {{VALUE}} !important;',
                        // Paragraph and content
                        '.body_dark {{WRAPPER}} p' => 'color: {{VALUE}} !important;',
                        '.body_dark {{WRAPPER}} p span' => 'color: {{VALUE}} !important;',
                        '.body_dark {{WRAPPER}} li' => 'color: {{VALUE}} !important;',
                        '.body_dark {{WRAPPER}} a:not(.elementor-button)' => 'color: {{VALUE}} !important;',
                        // Widget specific
                        '.body_dark {{WRAPPER}} .elementor-text-editor' => 'color: {{VALUE}} !important;',
                        '.body_dark {{WRAPPER}} .elementor-icon-box-title' => 'color: {{VALUE}} !important;',
                        '.body_dark {{WRAPPER}} .elementor-icon-box-description' => 'color: {{VALUE}} !important;',
                        '.body_dark {{WRAPPER}} .elementor-widget-heading .elementor-heading-title' => 'color: {{VALUE}} !important;',
                    ],
                ]
            );

            $element->add_control(
                'dark_mode_border_color', [
                    'label' => esc_html__( 'Border Color', 'docy-core' ),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        // Section borders
                        '.body_dark {{WRAPPER}}.elementor-section' => 'border-color: {{VALUE}} !important;',
                        // Column borders
                        '.body_dark {{WRAPPER}}.elementor-column > .elementor-element-populated' => 'border-color: {{VALUE}} !important;',
                        '.body_dark {{WRAPPER}} .elementor-column > .elementor-element-populated' => 'border-color: {{VALUE}} !important;',
                        // Widget borders
                        '.body_dark {{WRAPPER}} .elementor-widget-container' => 'border-color: {{VALUE}} !important;',
                        '.body_dark {{WRAPPER}} .elementor-widget-wrap > .elementor-element' => 'border-color: {{VALUE}} !important;',
                        // Container borders
                        '.body_dark {{WRAPPER}}.e-con' => 'border-color: {{VALUE}} !important;',
                    ],
                    'separator' => 'after'
                ]
            );


            $element->add_group_control(
                \Elementor\Group_Control_Background::get_type(),
                [
                    'name' => 'dark_mode_bg_color',
                    'types' => ['classic', 'gradient'],
                    'selector' => '
                        /* Sections */
                        .body_dark {{WRAPPER}}.elementor-section,
                        
                        /* Columns */
                        .body_dark {{WRAPPER}}.elementor-column > .elementor-element-populated,
                        .body_dark {{WRAPPER}} .elementor-column > .elementor-element-populated,
                        
                        /* Containers */
                        .body_dark {{WRAPPER}}.e-con,
                        .body_dark {{WRAPPER}} .dark_mode_sec_wrap,
                        
                        /* Widgets */
                        .body_dark {{WRAPPER}}.elementor-widget,
                        .body_dark {{WRAPPER}} .elementor-widget-container,
                        
                        /* Special Elements */
                        .body_dark {{WRAPPER}} .elementor-button:not(:hover),
                        .body_dark {{WRAPPER}} .elementor-icon,
                        .body_dark {{WRAPPER}} .elementor-icon-box-wrapper,
                        .body_dark {{WRAPPER}} .elementor-image-box-wrapper,
                        .body_dark {{WRAPPER}} .elementor-accordion-item
                    ',
                    'fields_options' => [
                        'background' => [
                            'label' => esc_html__('Background Type', 'docy-core'),
                        ],
                        'color' => [
                            'label' => esc_html__('Background Color', 'docy-core'),
                        ],
                        'gradient_angle' => [
                            'default' => [
                                'unit' => 'deg',
                                'size' => 180,
                            ],
                        ],
                    ],
                ]
            );

            // End Dark Mode Settings Section
            $element->end_controls_section();
        }

    }

}