<?php
add_shortcode( 'docy_tooltip', function( $atts, $content ) {
    ob_start();
    $atts = shortcode_atts( array(
        'id'    => '1',
        'content' => '',
        'trigger' => 'hover'
    ), $atts );

    $trigger = $atts['trigger'] ?? 'hover';
    wp_enqueue_script('tooltipster');
    ?>

    <a href="#" class="tooltips" data-tooltip-content="#tooltip-<?php echo esc_attr($atts['id']) ?>" title="<?php echo $atts['content'] ?>">
        <?php echo wp_kses_post($content); ?>
    </a>

    <script>
      (function($){
        $(document).ready(function(){
          /*--------------- tooltip js--------*/
          function tooltip() {
            if ($('.tooltips').length) {
              $('.tooltips').tooltipster({
                interactive: true,
                arrow: true,
                animation: 'grow',
                delay: 200,
                theme: 'tooltipster-default',
                trigger: '<?php echo esc_js($trigger) ?>',
              });
            }
          }
          tooltip();
          $('.tooltips_one').data('tooltip-custom-class', 'tooltip_blue').tooltip();
          $('.tooltips_two').data('tooltip-custom-class', 'tooltip_danger').tooltip();
        });
      })(jQuery);
    </script>

    <?php
    $html = ob_get_clean();
    return $html;
});