<?php
function docy_share_shortcode($atts) {
    $atts = shortcode_atts([
        'title' => 'show',
        'box-shadow' => 'no',
    ], $atts, 'docy_share');
    ob_start();
    $wrapper_classes = 'docy-share-wrap';
    if ($atts['box-shadow'] === 'yes') {
        $wrapper_classes .= ' bs-sm p-4 my-3 rounded-3';
    }
    ?>
    <div class="<?php echo esc_attr($wrapper_classes); ?>">
        <?php if ($atts['title'] === 'show') : ?>
            <h3 class="title"> <?php the_title(); ?> </h3>
        <?php endif; ?>
        <div class="social-links">
            <a href="mailto:?subject=<?php the_title(); ?>&amp;body= <?php esc_html_e( 'Check out this doc: ', 'docy-core' ); the_permalink(); ?>" target="_blank">
                <i class="icon_mail"></i>
            </a>
            <a href="https://www.facebook.com/share.php?u=<?php the_permalink(); ?>">
                <i class="social_facebook_circle"></i>
            </a>
            <a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink(); ?>">
                <i class="social_linkedin_square"></i>
            </a>
            <a href="https://x.com/share?url=<?php the_permalink(); ?>&amp;text=<?php the_title(); ?> &amp;hashtags=<?php echo site_url(); ?>">
                <i class="social_twitter"></i>
            </a>
        </div>
        <p> <?php echo esc_html__( 'Or copy link', 'docy-core' ); ?> </p>
        <div class="copy-url-wrap">
            <input readonly type="text" value="<?php the_permalink(); ?>" class="word-wrap">
            <div class="share-this-doc" data-success-message="success">
                <img src="<?php echo DOCY_DIR_IMG ?>/clone.svg" alt="<?php esc_attr_e( 'Clipboard Icon', 'docy-core' ); ?>">
            </div>
        </div>
    </div>

    <div class="docy-link-copied-wrap"></div>

    <script>
        ;(function ($) {
            "use strict";

            //================ Share Button ====================//
            // Copy the current page link to clipboard
            $(".share-this-doc").on("click", function (e) {
                e.preventDefault();
                let success_message = $(this).data("success-message");
                let $temp = $("<input>");
                $("body").append($temp);
                $temp.val($(location).attr("href")).select();
                document.execCommand("copy");
                $temp.remove();

                setTimeout(function () {
                    $(".docy-link-copied-wrap").text(success_message).addClass("copied");
                }, 500);

                setTimeout(function () {
                    $(".docy-link-copied-wrap").removeClass("copied");
                }, 3500);
            });

            $(".docy-link-copied-wrap").click(function () {
                $(this).removeClass("copied");
            });
        })(jQuery);
    </script>

	<?php
	return ob_get_clean();
}

add_shortcode( 'docy_share', 'docy_share_shortcode' );