<?php
namespace DocyCore\PostType;

class Header_Footer
{
    private static $_instance = null;

    public function __construct()
    {
        add_action('plugins_loaded', [$this, 'on_plugins_loaded']);
    }

    public static function instance(): ?Header_Footer
    {
        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    public function on_plugins_loaded()
    {
        add_action('init', [$this, 'register_post_type_header']);
        add_action('init', [$this, 'register_post_type_footer']);

        // Set default page template for new posts
        add_action('wp_insert_post', [$this, 'default_page_template'], 10, 3);
    }

    public function register_post_type_header()
    {
        if (post_type_exists('docy_header')) {
            return;
        }

        $labels = array(
            'name'                     => esc_html__('Headers', 'docy-core'),
            'singular_name'            => esc_html__('Header', 'docy-core'),
            'add_new'                  => esc_html__('Add New', 'docy-core'),
            'add_new_item'             => esc_html__('Add New Header', 'docy-core'),
            'edit_item'                => esc_html__('Edit Header', 'docy-core'),
            'new_item'                 => esc_html__('New Header', 'docy-core'),
            'view_item'                => esc_html__('View Header', 'docy-core'),
            'search_items'             => esc_html__('Search Headers', 'docy-core'),
            'not_found'                => esc_html__('No headers found', 'docy-core'),
            'not_found_in_trash'       => esc_html__('No headers found in Trash', 'docy-core'),
            'parent_item_colon'        => esc_html__('Parent Header:', 'docy-core'),
            'all_items'                => esc_html__('Headers', 'docy-core'),
            'archives'                 => esc_html__('Header Archives', 'docy-core'),
            'insert_into_item'         => esc_html__('Insert into header', 'docy-core'),
            'uploaded_to_this_item'    => esc_html__('Uploaded to this header', 'docy-core'),
            'filter_items_list'        => esc_html__('Filter headers list', 'docy-core'),
            'items_list_navigation'    => esc_html__('Headers list navigation', 'docy-core'),
            'items_list'               => esc_html__('Headers list', 'docy-core'),
            'item_published'           => esc_html__('Header published.', 'docy-core'),
            'item_published_privately' => esc_html__('Header published privately.', 'docy-core'),
            'item_reverted_to_draft'   => esc_html__('Header reverted to draft.', 'docy-core'),
            'item_scheduled'           => esc_html__('Header scheduled.', 'docy-core'),
            'item_updated'             => esc_html__('Header updated.', 'docy-core'),
        );

        $args = array(
            'labels'             => $labels,
            'public'             => true,
            'publicly_queryable' => true,
            'show_in_rest'       => true,
            'show_ui'            => true,
            'show_in_menu'       => false,
            'query_var'          => true,
            'rewrite'            => array('slug' => 'docy_header'),
            'capability_type'    => 'post',
            'has_archive'        => true,
            'hierarchical'       => false,
            'supports'           => array('title', 'elementor'),
            'menu_icon'          => 'dashicons-welcome-widgets-menus',
        );

        register_post_type('docy_header', $args);
    }

    public function register_post_type_footer()
    {
        if (post_type_exists('docy_footer')) {
            return;
        }

        $labels = array(
            'name'                     => esc_html__('Footers', 'docy-core'),
            'singular_name'            => esc_html__('Footer', 'docy-core'),
            'add_new'                  => esc_html__('Add New', 'docy-core'),
            'add_new_item'             => esc_html__('Add New Footer', 'docy-core'),
            'edit_item'                => esc_html__('Edit Footer', 'docy-core'),
            'new_item'                 => esc_html__('New Footer', 'docy-core'),
            'view_item'                => esc_html__('View Footer', 'docy-core'),
            'search_items'             => esc_html__('Search Footers', 'docy-core'),
            'not_found'                => esc_html__('No footers found', 'docy-core'),
            'not_found_in_trash'       => esc_html__('No footers found in Trash', 'docy-core'),
            'parent_item_colon'        => esc_html__('Parent Footer:', 'docy-core'),
            'all_items'                => esc_html__('Footers', 'docy-core'),
            'archives'                 => esc_html__('Footer Archives', 'docy-core'),
            'insert_into_item'         => esc_html__('Insert into footer', 'docy-core'),
            'uploaded_to_this_item'    => esc_html__('Uploaded to this footer', 'docy-core'),
            'filter_items_list'        => esc_html__('Filter footers list', 'docy-core'),
            'items_list_navigation'    => esc_html__('Footers list navigation', 'docy-core'),
            'items_list'               => esc_html__('Footers list', 'docy-core'),
            'item_published'           => esc_html__('Footer published.', 'docy-core'),
            'item_published_privately' => esc_html__('Footer published privately.', 'docy-core'),
            'item_reverted_to_draft'   => esc_html__('Footer reverted to draft.', 'docy-core'),
            'item_scheduled'           => esc_html__('Footer scheduled.', 'docy-core'),
            'item_updated'             => esc_html__('Footer updated.', 'docy-core'),
        );

        $args = array(
            'labels'             => $labels,
            'public'             => true,
            'publicly_queryable' => true,
            'show_in_rest'       => true,
            'show_ui'            => true,
            'show_in_menu'       => false,
            'query_var'          => true,
            'rewrite'            => array('slug' => 'docy_footer'),
            'capability_type'    => 'post',
            'has_archive'        => true,
            'hierarchical'       => false,
            'supports'           => array('title', 'elementor'),
            'menu_icon'          => 'dashicons-welcome-widgets-menus',
        );

        register_post_type('docy_footer', $args);
    }



    /**
     * Sets the default page template for new posts.
     *
     * @param int $post_ID The post ID.
     * @param $post The Post object.
     * @param bool $update Whether this is an existing post being updated.
     */
    public function default_page_template(int $post_ID, $post, bool $update): void
    {
        if (!$update && in_array($post->post_type, ['docy_header', 'docy_footer']) && $post->post_status == 'auto-draft') {
            update_post_meta($post_ID, '_wp_page_template', 'elementor_canvas');
        }
    }

}