<?php

/**
 * Class docy_acf_custom_fields
 */
class docy_acf_custom_fields {
	// vars
	var $settings;

	function __construct() {
		// settings
		// - these will be passed into the field class.
		$this->settings = array(
			'version' => '1.0.0',
			'url'     => plugin_dir_url( __FILE__ ),
			'path'    => plugin_dir_path( __FILE__ )
		);

		// include field
		add_action( 'acf/include_field_types', array( $this, 'docy_include_field' ) ); // v5
		add_action( 'acf/register_fields', array( $this, 'docy_include_field' ) ); // v4
	}

	function docy_include_field() {
		// include
		require_once __DIR__ . '/fields/class-docy-acf-field-margin-v5.php';
		require_once __DIR__ . '/fields/class-docy-acf-field-padding-v5.php';
		require_once __DIR__ . '/fields/class-docy-acf-field-typography-v5.php';
	}
}

// initialize
new docy_acf_custom_fields();

add_action( 'acf/init', function () {
	//List Style
	acf_register_block_type( array(
		'name'            => 'docy-list-style',
		'title'           => esc_html__( 'Docy List', 'docy-core' ),
		'description'     => esc_html__( 'A custom list style block by Docy.', 'docy-core' ),
		'render_callback' => 'docy_acf_block_list',
		'category'        => 'formatting',
		'icon'            => 'info',
		'keywords'        => array( 'list', 'list style', 'docy list' ),
	) );
} );

// Require the output files for each block
require_once __DIR__ . '/list.php';