<div class="docy-mobile-toc">
	<div class="mobile-toc">
		<div class="overlay" id="toc-overlay"></div>
		<!-- Button to toggle the Table of Contents -->
		<button class="fqmceZ table_content" aria-expanded="false" aria-controls="docy-toc">
			<?php esc_html_e('Table of Contents', 'docy'); ?>
		</button>

		<!-- Hidden Table of Contents, will appear above the button -->
		<aside class="bottom_table_content" id="docy-tocs" aria-hidden="true">
			<button class="close-toc">
				<img src="<?php echo DOCY_DIR_IMG ?>/icons/cross-icon.svg" alt="<?php esc_attr_e( 'Cross icon', 'docy') ?>">
			</button>
			<nav data-toggle="toc" class="nav-sidebar doc-nav">
				<!-- You can dynamically generate your TOC items here -->
			</nav>
		</aside>

		<!-- Button to show Share modal -->
		<button class="fqmceZ table_share_btn">
			<img src="<?php echo DOCY_DIR_IMG ?>/icons/share-icon.svg" alt="<?php esc_attr_e( 'Share icon', 'docy') ?>">
			<?php esc_html_e('Share', 'docy'); ?>
		</button>

		<!-- Hidden Share Modal -->
		<div class="docy-modal-content" id="share-modal" aria-hidden="true">

			<button class="close docy-close" aria-label="Close Share Modal">
				<img src="<?php echo DOCY_DIR_IMG ?>/icons/cross-icon.svg" alt="<?php esc_attr_e( 'Cross icon', 'docy') ?>">
			</button>

			<div class="docy-share-wrap">
				<div class="social-links">
					<a href="mailto:?subject=<?php the_title(); ?>&amp;body= <?php esc_html_e( 'Check out this page', 'docy' ); the_permalink(); ?>" target="_blank">
						<i class="icon_mail"></i>
					</a>
					<a href="https://www.facebook.com/share.php?u=<?php the_permalink(); ?>">
						<i class="social_facebook_circle"></i>
					</a>
					<a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink(); ?>">
						<i class="social_linkedin_square"></i>
					</a>
					<a href="https://twitter.com/share?url=<?php the_permalink(); ?>&amp;text=<?php the_title(); ?> &amp;hashtags=<?php echo esc_url(site_url()); ?>">
						<i class="social_twitter"></i>
					</a>
				</div>
				<p>Copy link</p>
				<div class="docy-copy-url-wrap">
					<div class="share-this-docs">
						<input readonly type="text" value="<?php the_permalink(); ?>" class="word-wrap">
						<img src="<?php echo get_template_directory_uri(); ?>/assets/img/clone.svg" alt="<?php esc_attr_e( 'Docy theme', 'docy' ); ?>">
					</div>
				</div>
			</div>
		</div>
	</div>
</div>