<?php
$opt        = get_option( 'docy_opt' );
$thumb_size = is_active_sidebar( 'sidebar_widgets' ) ? 'docy_410x220' : 'full';
// Post Meta
$is_post_meta = [
	'meta'         => $opt['is_post_meta'] ?? '1',
	'date'         => $opt['is_post_date'] ?? '1',
	'reading_time' => $opt['is_post_reading_time'] ?? '1',
	'cat'          => $opt['is_post_cat'] ?? '1',
	'author'       => $opt['is_post_author'] ?? '1'
];

$post_author_id = get_post_field( 'post_author', get_the_ID() );
$blog_column    = docy_opt( 'blog_column', 3 );

if ( ! empty( $_GET['blog_layout'] ) && $_GET['blog_layout'] == 'blog_category' ) {
	$blog_column = '4';
}
$is_masonry = docy_opt('is_blog_masonry');
$masonry_item = $is_masonry && docy_opt('blog_layout') == 'grid' ? 'masonry-item' : 'col-lg-' . esc_attr($blog_column) . ' col-sm-6';
$data_attr = $is_masonry && docy_opt('blog_layout') == 'grid' ? 'data-cols="' . esc_attr($blog_column) . '"' : '';
?>

<div class="<?php echo esc_attr($masonry_item) ?>" <?php echo $data_attr; ?>>
    <div class="blog_grid_post wow fadeInUp">
		<?php
		if ( ! is_search() ) {
			the_post_thumbnail( $thumb_size );
		}
		?>
        <div class="grid_post_content">
			<?php if ( $is_post_meta['meta'] == '1' ) : ?>
                <div class="post_tag">
					<?php if ( $is_post_meta['reading_time'] == '1' ) : ?>
                        <span class="meta"> <?php docy_reading_time( get_the_ID() ); ?> </span>
					<?php endif; ?>
					<?php if ( $is_post_meta['cat'] == '1' ) : ?>
                        <a class="cat" href="<?php Docy_helper()->first_category_link(); ?>">
							<?php Docy_helper()->first_category(); ?>
                        </a>
					<?php endif; ?>
                </div>
			<?php endif; ?>
            <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute() ?>">
                <h4 class="b_title">
					<?php Docy_helper()->limit_latter( get_the_title(), docy_opt( 'post_title_length', 45 ) ); ?>
                </h4>
            </a>

			<?php
			// Excerpt
			echo strip_shortcodes( Docy_helper()->excerpt( 'blog_excerpt', false ) );

			if ( $is_post_meta['author'] == '1' && $is_post_meta['meta'] == '1' ) : ?>
                <div class="media d-flex post_author">
                    <div class="round_img">
						<?php Docy_helper()->post_author_avatar(); ?>
                    </div>
                    <div class="media-body author_text">
                        <a href="<?php echo get_author_posts_url( $post_author_id ) ?>">
							<?php echo get_the_author_meta( 'display_name' ) ?>
                        </a>
						<?php if ( $is_post_meta['date'] == '1' ) : ?>
                            <div class="date"> <?php the_time( get_option( 'date_format' ) ); ?> </div>
						<?php endif; ?>
                    </div>
                </div>
			<?php endif; ?>
        </div>
    </div>
</div>