jQuery(document).ready(function($) {
    $('#sort-replies').on('change', function(e) {
        e.preventDefault();
        var sort = $(this).val();
        var topic_id = $('section[role="main"]').attr('id') || bbp_reply_ajax_obj.bbp_topic_id;

        var data = {
            action: 'sort_bbp_replies',
            sort: sort,
            topic_id: topic_id
        };
        console.log(data);
        $('#topic-' + topic_id + '-replies .reply-result' ).addClass('loading');
        $.post(bbp_reply_ajax_obj.ajax_url, data, function(response) {
            if(response.success) {
                $('#topic-' + topic_id + '-replies .reply-result').html(response.data.html);
                // Re-initialize .bbp-admin-dropdown-menu.nice-select after AJAX update
                if ($.fn.niceSelect) {
                    $('.bbp-admin-dropdown-menu.nice-select').niceSelect();
                }
            }
            $('#topic-' + topic_id + '-replies .reply-result').removeClass('loading');
        });
    });
});
