<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;


/**
 * Setup My Child Theme's textdomain.
 *
 * Declare textdomain for this child theme.
 * Translations can be filed in the /languages/ directory.
 */
function docy_child_theme_setup() {
    load_child_theme_textdomain( 'docy-child', get_stylesheet_directory() . '/languages' );
}
add_action( 'after_setup_theme', 'docy_child_theme_setup' );


// BEGIN ENQUEUE PARENT ACTION
if ( !function_exists( 'docy_child_thm_parent_css' ) ):
    function docy_child_thm_parent_css() {
        wp_enqueue_style (
            'docy-child-parent-root',
            trailingslashit ( get_template_directory_uri() ) . 'style.css'
        );
    }
endif;
add_action( 'wp_enqueue_scripts', 'docy_child_thm_parent_css', 10 );


//Custom code for rank math

// Remove Rank Math JSON-LD data from WebPage schema on pages


add_filter( 'rank_math/json_ld', function( $data, $jsonld ) {
	  if ( is_page( 'faqs' ) ) {
		unset($data['WebSite']);
	} else {
		unset($data['WebPage']);
		unset($data['WebSite']);
	}

    return $data;
}, 99, 2);

// END ENQUEUE PARENT ACTION
