<?php
/*
Plugin Name: Topbar
Description: WpEazy AI Launching Topbar with session dismiss (70% OFF).
Version: 1.0.0
Author: Spider Themes
*/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

// Enqueue CSS & JS
add_action('wp_enqueue_scripts', 'topbar_enqueue_assets');
function topbar_enqueue_assets() {
	wp_enqueue_style('topbar-style', plugin_dir_url(__FILE__) . 'assets/topbar.css');
	wp_enqueue_script('topbar-script', plugin_dir_url(__FILE__) . 'assets/topbar.js', array('jquery'), false, true);
}

// Display Topbar
add_action('wp_body_open', 'topbar_display');
function topbar_display() {
	// Check if cookie exists
	if (isset($_COOKIE['topbarDismissed']) && $_COOKIE['topbarDismissed'] == '1') {
		return; // don't output the topbar
	}
	?>
    <div id="topbar" class="topbar">
        <!-- Sparkle Effects -->
        <div class="sparkle">✨</div>
        <div class="sparkle">⭐</div>
        <div class="sparkle">✨</div>

        <!-- Left Content -->
        <div class="topbar-content">
            <span class="rocket-icon">🚀</span>
            <span class="topbar-text">
                WpEazy AI - The Ultimate AI Extension: <span class="highlight">70% OFF</span> for 7 Days Only!
            </span>
        </div>

        <!-- CTA Button -->
        <a href="https://spider-themes.net/wpeazyai/pricing/" class="cta-button">Grab The Deal</a>

        <!-- Close Button -->
        <button class="topbar-close" aria-label="Close">&times;</button>
    </div>
	<?php
}
