<div class="spe_image_slider">
    <div class="spe_slider_inner slider_two">
        <?php foreach( $settings['spe_slider_image'] as $img ) {
            $image_id = !empty($img['id']) ? $img['id'] : '';
            $img_attachment_meta = spel_el_image_caption($image_id);
            ?>
        <div>
            <div class="spe_slider_item">
                <?php echo '<img src="' . esc_attr( $img_attachment_meta['src'] ) . '">'; ?>
                <div class="spe_slider_content">
                    <h3><?php echo $img_attachment_meta['title']; ?></h3>
                    <p><?php echo $img_attachment_meta['caption']; ?></p>
                </div>
            </div>
        </div>
        <?php } ?>
    </div>
    <span class="pagingInfo_two"></span>
    <div class="spe_slider_nav_two">
        <i class="arrow_left slider_left_arrow slick-arrow"></i>
        <button class="spe_slider_btn spe_slider_btn_two play">
            <img class="one" src="<?php echo SPEL_PRO_IMG . '/play.svg' ?>" alt="<?php esc_attr_e('Play Icon', 'spider-elements-pro' ); ?>">
            <img class="two" src="<?php echo SPEL_PRO_IMG . '/push.svg' ?>" alt="<?php esc_attr_e('Push Icon', 'spider-elements-pro' ); ?>">
        </button>
        <i class="arrow_right slider_right_arrow slick-arrow"></i>
    </div>
    <div class="slider-progress">
        <div class="slider_progress_bar"></div>
    </div>
</div>

<script>
;
(function($) {
    'use strict';
    $(document).ready(function() {
        function mainSlider() {
            var sliderTimer = 3000;
            var $imageSlider = $(".slider_two");
            var $statusT = $(".pagingInfo_two");
            var $progressBar = $(".slider_progress_bar");
            var isPaused = false; // Initial state for autoplay control

            // Initialize Slick Slider
            $imageSlider.on("init reInit afterChange", function(event, slick, currentSlide) {
                var i = (currentSlide ? currentSlide : 0) + 1;
                $statusT.text(i + "/" + slick.slideCount);
            });

            $imageSlider.slick({
                autoplay: true,
                autoplaySpeed: sliderTimer,
                speed: 1500,
                dots: false,
                prevArrow: ".slider_left_arrow",
                nextArrow: ".slider_right_arrow",
                adaptiveHeight: true,
                pauseOnFocus: false,
                pauseOnHover: false,
                fade: <?php if ( 'yes' === $settings['slider_animation'] ) {
                        echo 'true';
                    }else{
                        echo 'false';
                    } ?>,
            });

            // Play/Pause Button Functionality
            $(".spe_slider_btn_two").on("click", function() {
                if (!$(this).hasClass("pause")) {
                    // If autoplay is running, pause it
                    $imageSlider.slick("slickPause");
                    isPaused = true; // Update state
                    $(this).removeClass("play").addClass("pause");
                    stopProgressBar(); // Stop progress bar
                } else {
                    // If autoplay is paused, resume it
                    $imageSlider.slick("slickPlay");
                    isPaused = false; // Update state
                    $(this).removeClass("pause").addClass("play");
                    startProgressBar(); // Restart progress bar
                }
            });

            // Start Progress Bar
            function startProgressBar() {
                $progressBar.css({
                    width: "100%",
                    transition: `width ${sliderTimer / 1000}s linear`
                });
            }

            // Stop Progress Bar
            function stopProgressBar() {
                $progressBar.css({
                    width: getComputedStyle($progressBar[0]).width, // Freeze current width
                    transition: "none"
                });
            }

            // Reset Progress Bar
            function resetProgressBar() {
                $progressBar.css({
                    width: "0%",
                    transition: "none"
                });
                setTimeout(() => startProgressBar(), 1250); // Restart with delay
            }

            startProgressBar(); // Initial Progress Bar Start

            $imageSlider.on("beforeChange", function() {
                resetProgressBar(); // Reset before slide changes
            });
        }

        mainSlider();
    });
})(jQuery);

</script>