<div class="spe_image_slider s_wraper">
    <div class="spe_slider_inner slider">
        <?php foreach( $settings['spe_slider_image'] as $img ) {
            $image_id = !empty($img['id']) ? $img['id'] : '';
            $img_attachment_meta = spel_el_image_caption($image_id);
            ?>
        <div>
            <div class="spe_slider_item">
                <?php echo '<img src="' . esc_attr( $img_attachment_meta['src'] ) . '">'; ?>
                <div class="spe_slider_content show">
                    <div class="ezd-container position-relative">
                        <h3><?php echo $img_attachment_meta['title']; ?></h3>
                        <div class="content_arrow show">
                            <i class="arrow_carrot-down"></i>
                        </div>
                        <p class="description"><?php echo $img_attachment_meta['caption']; ?></p>
                    </div>
                </div>
            </div>
        </div>
        <?php } ?>
    </div>
    <div class="buttons_control">
        <div class="ezd-container ezd-d-flex">
            <button class="spe_slider_btn spe_slider_btn_one play">
                <img class="one" src="<?php echo SPEL_PRO_IMG . '/push.svg' ?>" alt="<?php esc_attr_e('Push Icon', 'spider-elements-pro' ); ?>">
                <img class="two" src="<?php echo SPEL_PRO_IMG . '/play.svg' ?>" alt="<?php esc_attr_e('Play Icon', 'spider-elements-pro' ); ?>">
            </button>
            <span class="pagingInfo"></span>
        </div>
    </div>
        <?php if ( 'yes' === $settings['slider_arrows'] ) { ?>
            <div class="spe_slider_nav">
                <div class="left_arrow slick-arrow">
                    <i class="arrow_carrot-left"></i>
                </div>
                <div class="right_arrow slick-arrow">
                    <i class="arrow_carrot-right"></i>
                </div>
            </div>
        <?php } ?>
    <div class="slider-dots-box"></div>
</div>
<!-- js code  -->
<script>
;
(function($) {
    'use strict';
    $(document).ready(function() {
        var $status = $(".pagingInfo");
        var $slickElement = $(".slider");

        $(".spe_image_slider").each(function() {
            $(this)
                .find(".slider")
                .on(
                    "init reInit afterChange",
                    function(event, slick, currentSlide, nextSlide) {
                        //currentSlide is undefined on init -- set it to 0 in this case (currentSlide is 0 based)
                        var i = (currentSlide ? currentSlide : 0) + 1;
                        $status.text(i + "/" + slick.slideCount);
                    }
                );
        });

        $slickElement.slick({
            dots: true,
            pauseOnHover: false,
            arrows:  <?php if ( 'yes' === $settings['slider_arrows'] ) {
                echo 'true';
            }else{
                echo 'false';
            } ?>,
            autoplay:  <?php if ( 'yes' === $settings['slider_autoplay'] ) {
                echo 'true';
            }else{
                echo 'false';
            } ?>,
            speed: 1200,
            infinite: <?php if ( 'yes' === $settings['slider_infinite'] ) {
                echo 'true';
            }else{
                echo 'false';
            } ?>,
            fade: <?php if ( 'yes' === $settings['slider_animation'] ) {
                echo 'true';
            }else{
                echo 'false';
            } ?>,
            autoplaySpeed: 5000,
            slidesToShow: 1,
            adaptiveHeight: false,
            prevArrow: ".left_arrow",
            nextArrow: ".right_arrow",
            appendDots: $(".slider-dots-box"),
            dotsClass: "slider-dots",
        });

        $(".spe_slider_btn_one").on("click", function(e) {
            if ($(this).hasClass("pause")) {
                $(".slider").slick("slickPause");
                $(this).removeClass("pause");
                isPause = true;
                $(this).addClass("play");
            } else {
                $(".slider").slick("slickPlay");
                isPause = false;
                $(this).removeClass("play");
                $(this).addClass("pause");
                $(this).addClass("clicked");
            }
        });

        $(".left_arrow,.right_arrow").on('click', function(e) {
            $('.spe_slider_btn_one').addClass("clicked");
        });


        //ticking machine
        var percentTime;
        var tick, isPause;
        var time = 1;
        var progressBarIndex = 0;

        $(".slider-dots-box button").each(function(index) {
            var progress =
                "<div class='inProgress inProgress" + index + "'></div>";
            $(this).html(progress);
        });

        function startProgressbar() {
            resetProgressbar();
            percentTime = 0;
            tick = setInterval(interval, 50);
        }

        function interval() {
            if (isPause === false) {
                if (
                    $(
                        '.slider .slick-track div[data-slick-index="' +
                        progressBarIndex +
                        '"]'
                    ).attr("aria-hidden") === "true"
                ) {
                    progressBarIndex = $(
                        '.slider .slick-track div[aria-hidden="false"]'
                    ).data("slickIndex");
                    startProgressbar();
                } else {
                    
                    percentTime += 1 ;
                    
                    $(".inProgress" + progressBarIndex).css({
                        width: percentTime + "%",
                    });
                    if (percentTime >= 100) {
                        $(".slider").slick("slickNext");
                        progressBarIndex++;
                        if (progressBarIndex > 2) {
                            progressBarIndex = 0;
                        }
                        startProgressbar();
                    }
                }
            }
        }

        function resetProgressbar() {
            $(".inProgress").css({
                width: 0 + "%",
            });
            clearInterval(tick);
        }
        startProgressbar();
    });
    $('.content_arrow').on('click', function(e) {

        
        $('.spe_slider_content .description').slideToggle()

        if ($(this).hasClass('show')) {
            $('.content_arrow').removeClass('show');
        } else {
            $(this).toggleClass('show');
        }
    });
})(jQuery)
</script>