<?php

/**
 * Use namespace to avoid conflict
 */

namespace SPEL_PRO\Widgets;

use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class Flip Box
 * @package spider\Widgets
 * @since 1.0.0
 */
class Image_Slides extends Widget_Base
{
    public function get_name ()
    {
        return 'docy_image_slides';
    }

    public function get_title ()
    {
        return esc_html__('Image Slides', 'spider-elements-pro');
    }

    public function get_icon ()
    {
        return 'eicon-slides spel-icon';
    }

    public function get_keywords ()
    {
        return [ 'spider', 'image', 'slider', 'image slider' ];
    }

    public function get_categories ()
    {
        return [ 'spider-element-pro' ];
    }

	/**
	 * Name: get_style_depends()
	 * Desc: Register the required CSS dependencies for the frontend.
	 */
	public function get_style_depends(): array
    {
		return [ 'slick', 'slick-theme', 'elegant-icon', 'spel-main', 'spel-main-pro' ];
	}

	/**
	 * Name: get_script_depends()
	 * Desc: Register the required JS dependencies for the frontend.
	 */
	public function get_script_depends(): array
    {
		return [ 'slick' ];
	}


    /**
     * Name: register_controls()
     * Desc: Register controls for these widgets
     * Params: no params
     * Return: @void
     * Since: @1.0.0
     * Package: @spider-elements-pro
     * Author: spider-themes
     */
    protected function register_controls (): void
    {
        $this->elementor_content_control();
     $this->elementor_style_control();
    }


    /**
     * Name: elementor_content_control()
     * Desc: Register the Content Tab output on the Elementor editor.
     * Params: no params
     * Return: @void
     * Since: @1.0.0
     * Package: @spider-elements-pro
     * Author: spider-themes
     */
    public function elementor_content_control (): void
    {

        //===================== Select Preset ===========================//
        $this->start_controls_section(
            'style_sec',
            [
                'label' => esc_html__('Preset Skins', 'spider-elements-pro'),
            ]
        );

        $this->add_control(
            'style',
            [
                'label' => esc_html__('Style', 'spider-elements-pro'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    '1' => [
                        'icon' => 'img_slider1',
                        'title' => esc_html__('01 : Image Slider 1', 'spider-elements-pro')
                    ],
                    '2' => [
                        'icon' => 'img_slider2',
                        'title' => esc_html__('02 : Image Slider 2', 'spider-elements-pro'),
                    ],
                ],
                'default' => '1',
            ]
        );

        $this->end_controls_section(); //End Select Style

        $this->start_controls_section(
            'spe_slider_images',
            [
                'label' => __('Gallery', 'spider-elements-pro'),
            ]
        );
        $this->add_control(
            'spe_slider_image',
            [
                'type' => Controls_Manager::GALLERY,
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
			'slider_animation',
			[
				'label' => esc_html__( 'Fade',  'spider-elements-pro'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes',  'spider-elements-pro'),
				'label_off' => esc_html__( 'No',  'spider-elements-pro'),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

        $this->end_controls_section();


        $this->start_controls_section(
			'spe_slider_navigation',
			[
				'label' => esc_html__( 'Navigation',  'spider-elements-pro'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'style' => '1',
                ],
			]
		);

		$this->add_control(
			'slider_autoplay',
			[
				'label' => esc_html__( 'Autoplay',  'spider-elements-pro'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes',  'spider-elements-pro'),
				'label_off' => esc_html__( 'No',  'spider-elements-pro'),
				'return_value' => 'yes',
				'default' => 'yes',
                'condition' => [
                    'style' => '1',
                ],
			]
		);

        $this->add_control(
			'slider_arrows',
			[
				'label' => esc_html__( 'Arrows',  'spider-elements-pro'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes',  'spider-elements-pro'),
				'label_off' => esc_html__( 'No',  'spider-elements-pro'),
				'return_value' => 'yes',
				'default' => 'yes',
                'condition' => [
                    'style' => '1',
                ],
			]
		);

        $this->add_control(
			'slider_infinite',
			[
				'label' => esc_html__( 'Infinite',  'spider-elements-pro'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes',  'spider-elements-pro'),
				'label_off' => esc_html__( 'No',  'spider-elements-pro'),
				'return_value' => 'yes',
				'default' => 'yes',
                'condition' => [
                    'style' => '1',
                ],
			]
		);


		$this->end_controls_section();
    }


    /**
     * Name: elementor_style_control()
     * Desc: Register the Style Tab output on the Elementor editor.
     * Params: no params
     * Return: @void
     * Since: @1.0.0
     * Package: @spider-elements-pro
     * Author: spider-themes
     */
    public function elementor_style_control ()
    {
        $this->start_controls_section(
			'content_style_section',
			[
				'label' => esc_html__( 'Slider', 'spider-elements-pro'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'slider_height',
			[
				'label' => esc_html__( 'Height', 'spider-elements-pro'),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .spe_slider_item' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'caption_style_section',
			[
				'label' => esc_html__( 'Caption',  'spider-elements-pro'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'text_align',
			[
				'label' => esc_html__( 'Alignment',  'spider-elements-pro'),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left',  'spider-elements-pro'),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center',  'spider-elements-pro'),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right',  'spider-elements-pro'),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .spe_slider_inner .spe_slider_content' => 'text-align: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
    }


    /**
     * Name: elementor_render()
     * Desc: Render the widget output on the frontend.
     * Params: no params
     * Return: @void
     * Since: @1.0.0
     * Package: @spider-elements-pro
     * Author: spider-themes
     */
    protected function render ()
    {
        $settings = $this->get_settings_for_display();
        extract($settings); //extract all settings array to variables converted to name of key


        //================= Template Parts =================//
        include "templates/image-slides/image-slides-{$settings['style']}.php";
    }
}