<?php
/**
 * Use namespace to avoid conflict
 */

namespace SPEL_PRO\Widgets;

use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Flip Box
 *
 * @package spider\Widgets
 * @since   1.0.0
 */
class Flip_Box extends Widget_Base {

	public function get_name() {
		return 'docy_flip_box'; // ID of the widget (Don't change this name)
	}

	public function get_title() {
		return esc_html__( 'Flip Box', 'spider-elements-pro' );
	}

	public function get_icon() {
		return 'eicon-flip-box spel-icon';
	}

	public function get_keywords() {
		return [ 'spider', 'flip', 'box', 'flip box' ];
	}

	public function get_categories() {
		return [ 'spider-element-pro' ];
	}

    /**
     * Name: get_style_depends()
     * Desc: Register the required CSS dependencies for the frontend.
     */
    public function get_style_depends() {
        return [ 'spel-main-pro' ];
    }

    /**
     * Name: get_script_depends()
     * Desc: Register the required JS dependencies for the frontend.
     */
    public function get_script_depends(): array
    {
        return ['spel-el-pro-widgets' ];
    }


	/**
	 * Name: register_controls()
	 * Desc: Register controls for these widgets
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @spider-elements-pro
	 * Author: spider-themes
	 */
	protected function register_controls() {
		$this->elementor_content_control();
		$this->elementor_style_control();
	}


	/**
	 * Name: elementor_content_control()
	 * Desc: Register the Content Tab output on the Elementor editor.
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @spider-elements-pro
	 * Author: spider-themes
	 */
	public function elementor_content_control() {

		// ============================ Select Style  ===========================//
		$this->start_controls_section(
			'select_style', [
				'label' => __( 'Flip Box', 'spider-elements-pro' ),
			]
		);

		$this->add_control(
			'style', [
				'label'   => __( 'Reveal Effect', 'spider-elements-pro' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'vertical'   => __( 'Vertical', 'spider-elements-pro' ),
					'horizontal' => __( 'Horizontal', 'spider-elements-pro' ),
				],
				'default' => 'vertical',
			]
		);

		$this->end_controls_section(); // End Select Style


		// ============================ Front face Content ===========================//
		$this->start_controls_section(
			'section_front', [
				'label' => __( 'Front Part', 'spider-elements-pro' ),
			]
		);

		$this->add_control(
			'front_content_type',
			[
				'label'   => __( 'Content Type', 'spider-elements-pro' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'content'  => __( 'Content', 'spider-elements-pro' ),
					'template' => __( 'Saved Templates', 'spider-elements-pro' ),
				],
				'default' => 'content',
			]
		);

		$this->add_control(
			'front_template',
			[
				'label'     => __( 'Choose Template', 'spider-elements-pro' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => spel_get_el_templates(),
				'condition' => [
					'front_content_type' => 'template',
				],
			]
		);

		$this->add_control(
			'front_box_title',
			[
				'label'       => __( 'Title', 'spider-elements-pro' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'Docy cares deeply.',
				'condition'   => [
					'front_content_type' => 'content',
				],
			]
		);

		$this->add_control(
			'front_desc',
			[
				'label'       => __( 'Description', 'spider-elements-pro' ),
				'type'        => Controls_Manager::WYSIWYG,
				'label_block' => true,
				'default'     => 'lorem ipsum dolor sit amet, consectetur adipiscing elit.',
				'condition'   => [
					'front_content_type' => 'content',
				],
			]
		);

		$this->add_control(
			'front_box_image',
			[
				'label'     => __( 'Image', 'spider-elements-pro' ),
				'type'      => Controls_Manager::MEDIA,
				'separator' => 'before',
				'default'   => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'front_content_type' => 'content',
				],
			]
		);

		$this->add_control(
			'title-icon', [
				'label'       => __( 'Top Icon', 'spider-elements-pro' ),
				'type'        => Controls_Manager::ICONS,
				'label_block' => true,
				'separator'   => 'before',
				'condition'   => [
					'front_content_type' => 'content',
				],
			]
		);

		$this->add_control(
			'plus-icon', [
				'label'       => __( 'Action Button Icon', 'spider-elements-pro' ),
				'type'        => Controls_Manager::ICONS,
				'label_block' => true,
				'default'     => [
					'value'   => 'fas fa-plus',
					'library' => 'solid',
				],
				'separator'   => 'before'
			]
		);

		$this->end_controls_section();

		// ============================ Back face Content ===========================//
		$this->start_controls_section(
			'section_back', [
				'label' => __( 'Back part', 'spider-elements-pro' ),
			]
		);

		$this->add_control(
			'back_content_type',
			[
				'label'   => __( 'Content Type', 'spider-elements-pro' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'content'  => __( 'Content', 'spider-elements-pro' ),
					'template' => __( 'Saved Templates', 'spider-elements-pro' ),
				],
				'default' => 'content',
			]
		);

		$this->add_control(
			'back_template',
			[
				'label'     => __( 'Choose Template', 'spider-elements-pro' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => spel_get_el_templates(),
				'condition' => [
					'back_content_type' => 'template',
				],
			]
		);

		$this->add_control(
			'back_box_title',
			[
				'label'       => __( 'Title', 'spider-elements-pro' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'Spider Flipbox build for elementor.',
				'condition'   => [
					'back_content_type' => 'content',
				],
			]
		);

		$this->add_control(
			'back_box_content',
			[
				'label'       => __( 'Description', 'spider-elements-pro' ),
				'type'        => Controls_Manager::WYSIWYG,
				'label_block' => true,
				'default'     => 'Spider Flipbox build for elementor.',
				'condition'   => [
					'back_content_type' => 'content',
				],
			]
		);

		$this->add_control(
			'back_box_image',
			[
				'label'     => __( 'Image', 'spider-elements-pro' ),
				'type'      => Controls_Manager::MEDIA,
				'separator' => 'before',
				'default'   => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'condition'   => [
					'back_content_type' => 'content',
				],
			]
		);

		$this->add_control(
			'minus-icon', [
				'label'   => __( 'Close Icon', 'spider-elements-pro' ),
				'type'    => Controls_Manager::ICONS,
				'default' => [
					'value'   => 'fa-solid fa-xmark',
					'library' => 'solid',
				]
			]
		);

		$this->end_controls_section();
	}


	/**
	 * Name: elementor_style_control()
	 * Desc: Register the Style Tab output on the Elementor editor.
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @spider-elements-pro
	 * Author: spider-themes
	 */
	public function elementor_style_control() {

		//============================ flip box  ============================//
		$this->start_controls_section(
			'flip_box_style', [
				'label' => __( 'Flip Box ', 'spider-elements-pro' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'height',
			[
				'label'      => esc_html__( 'Height', 'spider-elements-pro' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'vh', 'custom' ],
				'range'      => [
					'px' => [
						'min' => 10,
						'max' => 1400,
					],
					'vh' => [
						'min' => 10,
						'max' => 100,
					],
				],
				'separator'  => 'before',
				'selectors'  => [
					'{{WRAPPER}} .spe_flip_box_inner .front_face,{{WRAPPER}} .spe_flip_box_inner .back_face' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'flip_border',
				'label'    => esc_html__( 'Border', 'spider-elements-pro' ),
				'selector' => '{{WRAPPER}} .spe_flip_box_inner .front_face, {{WRAPPER}} .spe_flip_box_inner .back_face',
			]
		);

		$this->add_responsive_control(
			'flip_box_radius', [
				'label'      => __( 'Border Radius', 'spider-elements-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .spe_flip_box_inner .front_face' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .spe_flip_box_inner .back_face'  => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();


		//============================Front part Tab Style ============================//
		$this->start_controls_section(
			'front_box_style', [
				'label' => __( 'Front Part', 'spider-elements-pro' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'title_align',
			[
				'label'     => esc_html__( 'Alignment', 'spider-elements-pro' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => [
					'left'   => [
						'title' => esc_html__( 'Left', 'spider-elements-pro' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'spider-elements-pro' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right'  => [
						'title' => esc_html__( 'Right', 'spider-elements-pro' ),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .spe_flip_box_inner .front_face' => 'text-align: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(), [
				'name'     => 'front_box__background',
				'types'    => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .spe_flip_box_inner .front_face',
			]
		);

		$this->add_responsive_control(
			'front_box_padding', [
				'label'      => __( 'Padding', 'spider-elements-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'separator'  => 'after',
				'selectors'  => [
					'{{WRAPPER}} .spe_flip_box_inner .front_face' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'title_heading',
			[
				'label'     => esc_html__( 'Title', 'spider-elements-pro' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'      => 'front_title_typo',
				'selector'  => '{{WRAPPER}} .spe_flip_box_inner .front_face h3',
				'separator' => 'before',
			]
		);

		$this->add_control(
			'front_title_color',
			[
				'label'     => __( 'Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .spe_flip_box_inner .front_face h3' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'front_title_margin', [
				'label'      => __( 'Margin', 'spider-elements-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .spe_flip_box_inner .front_face .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'desc_heading',
			[
				'label'     => esc_html__( 'Description', 'spider-elements-pro' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'      => 'front_desc_typo',
				'selector'  => '{{WRAPPER}} .spe_flip_box_inner .front_face p',
			]
		);

		$this->add_control(
			'desc_color',
			[
				'label'     => __( 'Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .spe_flip_box_inner .front_face p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'front_des_margin', [
				'label'      => __( 'Margin', 'spider-elements-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .spe_flip_box_inner .front_face p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		//========= Front Image Style ==========//
		$this->start_controls_section(
			'front_image_style', [
				'label' => __( 'Front Image', 'spider-elements-pro' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'front_image_width', [
				'label'      => __( 'Width', 'spider-elements-pro' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'vh', 'vw' ],
				'range'      => [
					'px' => [
						'min'  => 10,
						'max'  => 1400,
						'step' => 1,
					],
					'%'  => [
						'min'  => 10,
						'max'  => 100,
						'step' => 1,
					],
					'em' => [
						'min'  => 10,
						'max'  => 100,
						'step' => 1,
					],
					'vh' => [
						'min'  => 10,
						'max'  => 100,
						'step' => 1,
					],
					'vw' => [
						'min'  => 10,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .spe_flip_box_inner .front_face img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'front_image_radius', [
				'label'      => __( 'Border Radius', 'spider-elements-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'vh', 'vw' ],
				'selectors'  => [
					'{{WRAPPER}} .font_face_content img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		// margin
		$this->add_responsive_control(
			'front_image_margin', [
				'label'      => __( 'Margin', 'spider-elements-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'vh', 'vw' ],
				'selectors'  => [
					'{{WRAPPER}} .font_face_content img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		//=============================== Back Box Style Section ===============================//
		$this->start_controls_section(
			'back_box_style', [
				'label' => __( 'Back Part', 'spider-elements-pro' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'     => esc_html__( 'Justify Content', 'spider-elements-pro' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => [
					'start'   => [
						'title' => esc_html__( 'Left', 'spider-elements-pro' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'spider-elements-pro' ),
						'icon'  => 'eicon-text-align-center',
					],
					'end'  => [
						'title' => esc_html__( 'End', 'spider-elements-pro' ),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .spe_flip_box_inner .back_face' => 'justify-content: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(), [
				'name'     => 'back_box_background',
				'types'    => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .spe_flip_box_inner .back_face',
			]
		);

		$this->add_responsive_control(
			'bback_box_padding', [
				'label'      => __( 'Padding', 'spider-elements-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'separator'  => 'after',
				'selectors'  => [
					'{{WRAPPER}} .spe_flip_box_inner .back_face' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'back_title_heading',
			[
				'label'     => esc_html__( 'Title', 'spider-elements-pro' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'      => 'back_title_typo',
				'selector'  => '{{WRAPPER}} .spe_flip_box_inner .back_face h3',
				'separator' => 'before',
			]
		);

		$this->add_control(
			'back_title_color',
			[
				'label'     => __( 'Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .spe_flip_box_inner .back_face h3' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'sub_title',
			[
				'label'     => esc_html__( 'Description', 'spider-elements-pro' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'      => 'back_content_typo',
				'selector'  => '{{WRAPPER}} .spe_flip_box_inner .back_face p',
			]
		);
		$this->add_control(
			'back_content_color',
			[
				'label'     => __( 'Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .spe_flip_box_inner .back_face p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		//================================icon section========================
		$this->start_controls_section(
			'icon_style', [
				'label' => __( 'Icon ', 'spider-elements-pro' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		// flip box front and back style
		$this->start_controls_tabs(
			'style_tab_title_tabs'
		);



		//========================= flip box Top icon========================
		$this->start_controls_tab(
			'style_tabs_title_top',
			[
				'label' => __( 'Top', 'spider-elements-pro' ),
			]
		);
		
		$this->add_control(
			'front_icon_color',
			[
				'label'     => __( 'Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .font_face_content .title-icon' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'icon_size',
			[
				'label'      => esc_html__( 'Size', 'spider-elements-pro' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default'    => [
					'unit' => 'px',
					'size' => 20,
				],
				'selectors'  => [
					'{{WRAPPER}} .font_face_content .title-icon' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab(); //End flip box Top icon



		//========================= flip box front icon========================
		$this->start_controls_tab(
			'style_tab_title_normal',
			[
				'label' => __( 'Front', 'spider-elements-pro' ),
			]
		);

		$this->add_control(
			'front_button_color',
			[
				'label'     => __( 'Background', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .spe_flip_box_inner .icon' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'icon_color',
			[
				'label'     => __( 'Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .spe_flip_box_inner .icon' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab(); //End flip box front icon


		//============================= flip box back icon =============================
		$this->start_controls_tab(
			'flip_back-icon', [
				'label' => __( 'back', 'spider-elements-pro' ),
			]
		);

		$this->add_control(
			'back_button_color',
			[
				'label'     => __( 'Background', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .spe_flip_box_inner .flip_button_close' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'back_icon_color',
			[
				'label'     => __( 'Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .spe_flip_box_inner .flip_button_close' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab(); // End flip box back icon ============================


		$this->end_controls_section(); // End icon Section

	}


	/**
	 * Name: elementor_render()
	 * Desc: Render the widget output on the frontend.
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @spider-elements-pro
	 * Author: spider-themes
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		extract( $settings ); //extract all settings array to variables converted to name of key

        //================= Template Parts =================//
        include "templates/flip-box/flip-box-1.php";
    }
}