<?php
/**
 * Use namespace to avoid conflict
 */

namespace SPEL_PRO\Widgets;

use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Flip Box
 *
 * @package spider\Widgets
 * @since   1.0.0
 */
class Feature_Box extends Widget_Base {

	public function get_name() {
		return 'spe_feature_box'; // ID of the widget (Don't change this name)
	}

	public function get_title() {
		return esc_html__( 'Feature Box', 'spider-elements-pro' );
	}

	public function get_icon() {
		return 'eicon-info-box spel-icon';
	}

	public function get_keywords() {
		return [ 'spider', 'feature', 'box', 'link' ];
	}

	public function get_categories() {
		return [ 'spider-element-pro' ];
	}

	/**
	 * Name: get_style_depends()
	 * Desc: Register the required CSS dependencies for the frontend.
	 */
	public function get_style_depends(): array
    {
		return [ 'spel-main-pro' ];
	}

	/**
	 * Name: get_script_depends()
	 * Desc: Register the required JS dependencies for the frontend.
	 */
	public function get_script_depends(): array
    {
		return [ 'scroll-parallax' ];
	}


	/**
	 * Name: register_controls()
	 * Desc: Register controls for these widgets
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @spider-elements-pro
	 * Author: spider-themes
	 */
	protected function register_controls(): void
    {
		$this->elementor_content_control();
		$this->elementor_style_control();
	}

	/**
	 * Name: elementor_content_control()
	 * Desc: Register the Content Tab output on the Elementor editor.
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @spider-elements-pro
	 * Author: spider-themes
	 */
	public function elementor_content_control(): void
    {

		// ============================ Font face Content ===========================//
		$this->start_controls_section(
			'feature_top_content', [
				'label' => esc_html__( 'Feature Content', 'spider-elements-pro' ),
			]
		);

		$this->add_control(
			'content_type', [
				'label'   => esc_html__( 'Content Type', 'spider-elements-pro' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'content'     => esc_html__( 'Contents', 'spider-elements-pro' ),
					'el_template' => esc_html__( 'Saved Template', 'spider-elements-pro' ),
				],
				'default' => 'content',
			]
		);

		$this->add_control(
			'feature_title', [
				'label'       => esc_html__( 'Title', 'spider-elements-pro' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'Feature Box Title',
				'condition'   => [
					'content_type' => 'content'
				]
			]
		);

		$this->add_control(
			'normal_content', [
				'label'       => esc_html__( 'Content', 'spider-elements-pro' ),
				'type'        => Controls_Manager::WYSIWYG,
				'label_block' => true,
				'default'     => esc_html__( 'Feature Content', 'spider-elements-pro' ),
				'condition'   => [
					'content_type' => 'content'
				]
			]
		);

		$this->add_control(
			'feature_box_image', [
				'label'     => esc_html__( 'Image', 'spider-elements-pro' ),
				'type'      => Controls_Manager::MEDIA,
				'default'   => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'content_type' => 'content'
				]
			]
		);

		$this->add_control(
			'el_content', [
				'label'       => esc_html__( 'Select Template', 'spider-elements-pro' ),
				'type'        => Controls_Manager::SELECT,
				'options'     => spel_get_el_templates(),
				'label_block' => true,
				'default'     => esc_html__( 'Accordion Content', 'spider-elements-pro' ),
				'condition'   => [
					'content_type' => 'el_template'
				]
			]
		);

		$this->add_control(
			'feature_icon', [
				'label'   => esc_html__( 'Icon', 'spider-elements-pro' ),
				'type'    => Controls_Manager::ICONS,
				'default' => [
					'value'   => 'arrow_right',
					'library' => 'ElegantIcons',
				],
			]
		);

		$this->add_control(
			'box_url', [
				'label'   => esc_html__( 'Box URL', 'spider-elements-pro' ),
				'type'    => Controls_Manager::URL,
                'options'     => [ 'url', 'is_external', 'spider-elements-pro' ],
                'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
				'default' => [
					'url' => '#',
				],
			]
		);

		$this->end_controls_section(); //
	}

	/**
	 * Name: elementor_style_control()
	 * Desc: Register the Style Tab output on the Elementor editor.
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @spider-elements-pro
	 * Author: spider-themes
	 */

	public function elementor_style_control() {

        //============================ Features Box section ============================//
		$this->start_controls_section(
			'feature_box_style', [
				'label' => esc_html__( 'Feature Box', 'spider-elements-pro' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(), [
				'name'     => 'box_background',
				'types'    => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .spe_features_box_item',
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(), [
				'name'     => 'feature_box_shadow',
				'selector' => '{{WRAPPER}} .spe_features_box_item',
			]
		);

		$this->add_responsive_control(
			'feature_box_height',
			[
				'label'      => esc_html__( 'Height', 'spider-elements-pro' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'vh', 'custom' ],
				'range'      => [
					'px' => [
						'min' => 10,
						'max' => 1400,
					],
					'vh' => [
						'min' => 10,
						'max' => 100,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .spe_features_box_item' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'box_padding', [
				'label'      => esc_html__( 'Padding', 'spider-elements-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .spe_features_box_item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'border',
				'selector' => '{{WRAPPER}} .spe_features_box_item',
				'separator'=> 'before',
			]
		);

		$this->add_responsive_control(
			'box_radius', [
				'label'      => esc_html__( 'Border Radius', 'spider-elements-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .spe_features_box_item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();


		//============================ Features box contents Style section ============================//
		$this->start_controls_section(
			'feature_box_contents_style_tab', [
				'label' => esc_html__( 'Contents', 'spider-elements-pro' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'feature_title_options', [
				'label'     => esc_html__( 'Title', 'spider-elements-pro' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'     => 'feature_title_typo',
				'selector' => '{{WRAPPER}} .spe_features_box_item .spe_fe_title',
			]
		);

		$this->add_control(
			'feature_title_color',
			[
				'label'     => esc_html__( 'Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .spe_features_box_item .spe_fe_title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'feature_des_options', [
				'label'     => esc_html__( 'Description', 'spider-elements-pro' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'      => 'feature_desc_typo',
				'selector'  => '{{WRAPPER}} .spe_features_box_item p',
				'separator' => 'before',
			]
		);

		$this->add_control(
			'feature_desc_color',
			[
				'label'     => esc_html__( 'Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .spe_features_box_item p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'feature_desc_margin', [
				'label'      => esc_html__( 'Margin', 'spider-elements-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .spe_features_box_item p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'feature_box_icon', [
				'label' => esc_html__( 'Icon', 'spider-elements-pro' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'icon_size', [
				'label'      => esc_html__( 'Size', 'spider-elements-pro' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default'    => [
					'unit' => 'px',
				],
				'selectors'  => [
					'{{WRAPPER}} .spe_features_box_item .features_box_layer .icon i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .spe_features_box_item .features_box_layer .icon svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		//=================// feature box icon normal/hover style tabs ====================
		$this->start_controls_tabs(
			'feature_box_icon_tabs'
		);

		//======== feature box icon normal style
		$this->start_controls_tab(
			'feature_box_icon_normal_style', [
				'label' => esc_html__( 'Normal', 'spider-elements-pro' ),
			]
		);

		$this->add_control(
			'icon_color', [
				'label'     => esc_html__( 'Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .spe_features_box_item .features_box_layer .icon i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .spe_features_box_item .features_box_layer .icon svg path' => 'fill: {{VALUE}}; stroke: {{VALUE}}',
				)
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(), [
				'name'     => 'icon_normal_background',
				'types'    => [ 'classic', 'gradient' ],
				'exclude'  => [ 'image' ],
				'selector' => '{{WRAPPER}} .spe_features_box_item .features_box_layer .icon',
			]
		);

		$this->end_controls_tab(); //End Normal Tab icon

		//====== feature box icon hover style
		$this->start_controls_tab(
			'feature_box_icon_hover_style', [
				'label' => esc_html__( 'Hover', 'spider-elements-pro' ),
			]
		);

		$this->add_control(
			'icon_hover_color', [
				'label'     => esc_html__( 'Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .spe_features_box_item .features_box_layer:hover .icon i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .spe_features_box_item .features_box_layer:hover .icon svg path' => 'fill: {{VALUE}}; stroke: {{VALUE}}',
				)
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name'     => 'icon_hover_background',
				'types'    => [ 'classic', 'gradient' ],
				'exclude'  => [ 'image' ],
				'selector' => '{{WRAPPER}} .spe_features_box_item .features_box_layer:hover .icon',
			]
		);

		$this->end_controls_tab(); //End Hover Tab icon
		$this->end_controls_tabs(); // End Control Tabs

		$this->add_responsive_control(
			'icon_padding', [
				'label'      => esc_html__( 'Padding', 'spider-elements-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'separator'  => 'before',
				'selectors'  => [
					'{{WRAPPER}} .spe_features_box_item .features_box_layer .icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section(); //

	}


	/**
	 * Name: elementor_render()
	 * Desc: Render the widget output on the frontend.
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @spider-elements-pro
	 * Author: spider-themes
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		extract( $settings ); //extract all settings array to variables converted to name of key

		//================= Template Parts =================//
		include "templates/feature-box/feature-box-1.php";
	}
}