<?php
/**
 * Use namespace to avoid conflict
 */

namespace SPEL_PRO\Widgets;

use Elementor\Group_Control_Background;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Flip Box
 * @package spider\Widgets
 * @since 1.0.0
 */
class Business_Hours extends Widget_Base {

	public function get_name() {
		return 'spel_business_hours'; // ID of the widget (Don't change this name)
	}

	public function get_title() {
		return esc_html__( 'Business Hours', 'spider-elements-pro' );
	}

	public function get_icon() {
		return 'eicon-clock-o spel-icon';
	}

	public function get_keywords() {
		return [ 'spider', 'business', 'hours', 'time', 'schedule', 'open', 'close' ];
	}

	public function get_categories(): array
    {
		return [ 'spider-element-pro' ];
	}

	/**
	 * Name: get_style_depends()
	 * Desc: Register the required CSS dependencies for the frontend.
	 */
	public function get_style_depends(): array
    {
		return [ 'spel-main-pro' ];
	}


	/**
	 * Name: register_controls()
	 * Desc: Register controls for these widgets
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @spider-elements-pro
	 * Author: spider-themes
	 */
	protected function register_controls() {
		$this->elementor_content_control();
		$this->elementor_style_control();
	}


	/**
	 * Name: elementor_content_control()
	 * Desc: Register the Content Tab output on the Elementor editor.
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @spider-elements-pro
	 * Author: spider-themes
	 */
	public function elementor_content_control() {

		//================= Business Hours ====================//
		$this->start_controls_section(
			'business_hours_sec', [
				'label' => esc_html__( 'Preset', 'spider-elements-pro' ),
			]
		);

		$this->add_control(
			'style', [
				'label'   => esc_html__( 'Style', 'spider-elements-pro' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'static'  => esc_html__( 'Static', 'spider-elements-pro' ),
					'dynamic' => esc_html__( 'Dynamic', 'spider-elements-pro' ),
				],
				'default' => 'static',
			]
		);

		$this->add_control(
			'dynamic_timezone', [
				'label'     => esc_html__( 'Timezone', 'spider-elements-pro' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'default',
				'options'   => [
					'default' => 'Website Time',
					'-0'      => 'UT or UTC - GMT -0',
					'+1'      => 'CET - GMT+1',
					'+2'      => 'EET - GMT+2',
					'+3'      => 'MSK - GMT+3',
					'+4'      => 'SMT - GMT+4',
					'+5'      => 'PKT - GMT+5',
					'+5.5'    => 'IND - GMT+5.5',
					'+6'      => 'OMSK / BD - GMT+6',
					'+7'      => 'CXT - GMT+7',
					'+8'      => 'CST / AWST / WST - GMT+8',
					'+9'      => 'JST - GMT+9',
					'+10'     => 'EAST - GMT+10',
					'+11'     => 'SAKT - GMT+11',
					'+12'     => 'IDLE  - GMT+12',
					'+13'     => 'NZDT  - GMT+13',
					'-1'      => 'WAT  - GMT-1',
					'-2'      => 'AT  - GMT-2',
					'-3'      => 'ART  - GMT-3',
					'-4'      => 'AST  - GMT-4',
					'-5'      => 'EST  - GMT-5',
					'-6'      => 'CST  - GMT-6',
					'-7'      => 'MST  - GMT-7',
					'-8'      => 'PST  - GMT-8',
					'-9'      => 'AKST  - GMT-9',
					'-10'     => 'HST  - GMT-10',
					'-11'     => 'NT  - GMT-11',
					'-12'     => 'IDLW  - GMT-12',
					'custom'  => "Custom",
				],
				'condition' => [
					'style' => 'dynamic',
				],
			]
		);

		$this->add_control(
			'custom_timezone_input', [
				'label'       => esc_html__( 'Custom Timezone', 'spider-elements-pro' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => '+6',
				'placeholder' => '+6',
				'condition'   => [
					'dynamic_timezone' => 'custom',
					'style'            => 'dynamic',
				]
			]
		);

		$this->end_controls_section(); // End Business Hours


		//================= Business Days & Times ====================//
		$this->start_controls_section(
			'business_days_layout', [
				'label'     => esc_html__( 'Business Days & Times', 'spider-elements-pro' ),
				'condition' => [
					'style' => 'static',
				]
			]
		);

		$repeater = new Repeater();
		$repeater->add_control(
			'enter_day', [
				'label'       => esc_html__( 'Enter Day', 'spider-elements-pro' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'Sunday',
				'dynamic'     => [ 'active' => true ],
			]
		);

		$repeater->add_control(
			'enter_time', [
				'label'       => esc_html__( 'Enter Time', 'spider-elements-pro' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => '10:00 AM - 6:00 PM',
				'dynamic'     => [ 'active' => true ],
			]
		);

		$repeater->add_control(
			'current_styling_divider', [
				'type' => Controls_Manager::DIVIDER,
			]
		);

		$repeater->add_control(
			'current_styling_heading', [
				'label' => esc_html__( 'Styling', 'spider-elements-pro' ),
				'type'  => Controls_Manager::HEADING,
			]
		);

		$repeater->add_control(
			'highlight_this', [
				'label'        => esc_html__( 'Style This Day', 'spider-elements-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$repeater->add_control(
			'business_day_color', [
				'label'     => esc_html__( 'Day Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#db6159',
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .spe-business-day-off' => 'color: {{VALUE}}',
				],
				'condition' => [
					'highlight_this' => 'yes',
				],
			]
		);

		$repeater->add_control(
			'business_timing_color', [
				'label'     => esc_html__( 'Time Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#db6159',
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .spe-business-time-off' => 'color: {{VALUE}}',
				],
				'condition' => [
					'highlight_this' => 'yes',
				],
			]
		);

		$repeater->add_group_control(
			\Elementor\Group_Control_Background::get_type(), [
				'name'      => 'business_background_color',
				'types'     => [ 'classic', 'gradient' ],
				'exlude'    => [ 'image' ],
				'selector'  => '{{WRAPPER}} .your-class',
				'condition' => [
					'highlight_this' => 'yes',
				],
			]
		);

		$this->add_control(
			'business_days_times', [
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => [
					[
						'enter_day'  => esc_html__( 'Monday', 'spider-elements-pro' ),
						'enter_time' => '10:00 AM - 6:00 PM',
					],
					[
						'enter_day'  => esc_html__( 'Tuesday', 'spider-elements-pro' ),
						'enter_time' => '10:00 AM - 6:00 PM',
					],
					[
						'enter_day'  => esc_html__( 'Wednesday', 'spider-elements-pro' ),
						'enter_time' => '10:00 AM - 6:00 PM',
					],
					[
						'enter_day'  => esc_html__( 'Thursday', 'spider-elements-pro' ),
						'enter_time' => '10:00 AM - 6:00 PM',
					],
					[
						'enter_day'  => esc_html__( 'Friday', 'spider-elements-pro' ),
						'enter_time' => '10:00 AM - 6:00 PM',
					],
					[
						'enter_day'  => esc_html__( 'Saturday', 'spider-elements-pro' ),
						'enter_time' => '10:00 AM - 6:00 PM',
					],
					[
						'enter_day'      => esc_html__( 'Sunday', 'spider-elements-pro' ),
						'enter_time'     => esc_html__( 'Closed', 'spider-elements-pro' ),
						'highlight_this' => 'yes',
					],
				],
				'title_field' => '{{{ enter_day }}}',
			]
		);

		$this->end_controls_section(); //End Business Days & Times


		//================= Dynamic Days & Times ====================//
		$this->start_controls_section(
			'dynamic_days_times_sec',
			[
				'label'     => __( 'Dynamic Days & Times', 'spider-elements-pro' ),
				'condition' => [
					'style' => 'dynamic',
				]
			]
		);

		$repeater = new Repeater();
		$repeater->add_control(
			'dynamic_enter_day', [
				'label'   => esc_html__( 'Day Level', 'spider-elements-pro' ),
				'type'    => Controls_Manager::TEXT,
				'dynamic' => [ 'active' => true, ],
				'default' => esc_html__( 'Monday', 'spider-elements-pro' ),
			]
		);

		$repeater->add_control(
			'dynamic_start_time', [
				'label'       => esc_html__( 'Start Time', 'spider-elements-pro' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => '09:00 AM',
				'placeholder' => '09:00 AM',
				'dynamic'     => [ 'active' => true, ],
				'condition'   => [
					'dynamic_close_this!' => 'yes',
				]
			]
		);

		$repeater->add_control(
			'dynamic_end_time', [
				'label'       => esc_html__( 'End Time', 'spider-elements-pro' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => '05:00 PM',
				'placeholder' => '05:00 PM',
				'dynamic'     => [ 'active' => true, ],
				'condition'   => [
					'dynamic_close_this!' => 'yes',
				]
			]
		);

		$repeater->add_control(
			'dynamic_close_this', [
				'label'        => esc_html__( 'Close This Day', 'spider-elements-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'no',
				'separator'    => 'before',
			]
		);

		$repeater->add_control(
			'dynamic_close_text', [
				'label'     => esc_html__( 'Close Level', 'spider-elements-pro' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => __( 'Closed', 'spider-elements-pro' ),
				'dynamic'   => [ 'active' => true, ],
				'condition' => [
					'dynamic_close_this' => 'yes',
				],
			]
		);

		$this->add_control(
			'dynamic_days_times',
			[
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => [
					[
						'dynamic_enter_day'  => esc_html__( 'Monday', 'spider-elements-pro' ),
						'dynamic_start_time' => '09:00 AM',
						'dynamic_end_time'   => '05:00 PM',
					],

					[
						'dynamic_enter_day'  => esc_html__( 'Tuesday', 'spider-elements-pro' ),
						'dynamic_start_time' => '09:00 AM',
						'dynamic_end_time'   => '05:00 PM',
					],

					[
						'dynamic_enter_day'  => esc_html__( 'Wednesday', 'spider-elements-pro' ),
						'dynamic_start_time' => '09:00 AM',
						'dynamic_end_time'   => '05:00 PM',
					],

					[
						'dynamic_enter_day'  => esc_html__( 'Thursday', 'spider-elements-pro' ),
						'dynamic_start_time' => '09:00 AM',
						'dynamic_end_time'   => '05:00 PM',
					],

					[
						'dynamic_enter_day'  => esc_html__( 'Friday', 'spider-elements-pro' ),
						'dynamic_start_time' => '09:00 AM',
						'dynamic_end_time'   => '05:00 PM',
					],

					[
						'dynamic_enter_day'  => esc_html__( 'Saturday', 'spider-elements-pro' ),
						'dynamic_start_time' => '09:00 AM',
						'dynamic_end_time'   => '05:00 PM',
					],

					[
						'dynamic_enter_day'  => esc_html__( 'Sunday', 'spider-elements-pro' ),
						'dynamic_start_time' => '09:00 AM',
						'dynamic_end_time'   => '05:00 PM',
						'dynamic_close_this' => 'yes',
						'dynamic_close_text' => 'Closed',
					],
				],
				'title_field' => '{{{ dynamic_enter_day }}}',
			]
		);

		$this->end_controls_section(); // End Dynamic Days & Times


		//================= Dynamic Additional ====================//
		$this->start_controls_section(
			'dynamic_additional_sec', [
				'label'     => __( 'Additional', 'spider-elements-pro' ),
				'condition' => [
					'style' => 'dynamic',
				]
			]
		);

		$this->add_control(
			'dynamic_open_day', [
				'label'     => esc_html__( 'Open Status', 'spider-elements-pro' ),
				'type'      => Controls_Manager::WYSIWYG,
				'default'   => __( 'Office Open. Right now we are available for service.', 'spider-elements-pro' ),
				'dynamic'   => [
					'active' => true,
				],
				'condition' => [
					'style' => 'dynamic',
				],
			]
		);

		$this->add_control(
			'dynamic_close_day', [
				'label'     => esc_html__( 'Close Status', 'spider-elements-pro' ),
				'type'      => Controls_Manager::WYSIWYG,
				'default'   => esc_html__( 'Office Closed. Right now we are not available.', 'spider-elements-pro' ),
				'dynamic'   => [
					'active' => true,
				],
				'condition' => [
					'style' => 'dynamic',
				],
			]
		);

		$this->add_control(
			'dynamic_time_separator', [
				'label'     => esc_html__( 'Separator', 'spider-elements-pro' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => '-',
				'dynamic'   => [
					'active' => true,
				],
				'condition' => [
					'style' => 'dynamic',
				],
				'separator' => 'before',
			]
		);

		$this->end_controls_section(); // End Dynamic Additional

	}


	/**
	 * Name: elementor_style_control()
	 * Desc: Register the Style Tab output on the Elementor editor.
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @spider-elements-pro
	 * Author: spider-themes
	 */
	public function elementor_style_control() {


	}


	/**
	 * Name: elementor_render()
	 * Desc: Render the widget output on the frontend.
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @spider-elements-pro
	 * Author: spider-themes
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		extract( $settings ); //extract all settings array to variables converted to name of key

		$business_days_times = ! empty( $settings[ 'business_days_times' ] ) ? $settings[ 'business_days_times' ] : '';

		if ( $settings[ 'style' ] == 'static' ) {
			//$this->render_static($settings);
		} elseif ( $settings[ 'style' ] == 'dynamic' ) {
			$this->render_dynamic( $settings );
		}
	}

	// render dynamic
	public function render_dynamic() {
		$settings = $this->get_settings_for_display();
		extract( $settings ); //extract all settings array to variables converted to name of key

		if ( ! empty( $settings[ 'dynamic_days_times' ] ) ) {
			$availabelStatus = '';

			echo '<div class="spe-ep-business-hours-inner">';

                foreach ( $settings[ 'dynamic_days_times' ] as $index => $item ) {

                    $day_settings = $this->get_repeater_setting_key( 'dynamic_enter_day', 'dynamic_days_times', $index );
                    $this->add_inline_editing_attributes( $day_settings );

                    $time_settings = $this->get_repeater_setting_key( 'dynamic_enter_time', 'dynamic_days_times', $index );
                    $this->add_inline_editing_attributes( $time_settings );

	                // Attributes
	                $this->add_render_attribute( 'wrapper', 'class', 'elementor-repeater-item-' . $item[ '_id' ] );
                    ?>
<div <?php echo $this->get_render_attribute_string('wrapper') ?>>
    <div>
        <span>
            <span><?php echo esc_html( ucwords( $item[ 'dynamic_enter_day' ] ) ); ?></span>
        </span>
        <span>
            <span>
                <span>
                    <?php
                                        if ( $item[ 'dynamic_close_this' ] != 'yes' ) {
                                         echo esc_html( $item[ 'dynamic_start_time' ] );
                                        } else {
                                         echo esc_html( $item[ 'dynamic_close_text' ] );
                                        }
                                        ?>
                </span>
                <span class="dynamic-separator">
                    <?php
                                        if ( $item[ 'dynamic_close_this' ] != 'yes' ) {
                                            echo esc_html( $settings[ 'dynamic_time_separator' ] );
                                        }
                                        ?>
                </span>
                <span>
                    <?php
                                        if ( $item[ 'dynamic_close_this' ] != 'yes' ) {
                                            echo esc_html( $item[ 'dynamic_end_time' ] );
                                        }
                                        $thisDay = substr( ucwords( $item[ 'dynamic_enter_day' ] ), 0, 3 );
                                        if ( $settings[ 'dynamic_timezone' ] == 'default' ) {
                                            $cur_Date = date( 'D' );
                                        } else {
                                            $cur_Date = strtotime( $this->set_time_zone() );
                                            $cur_Date = date( 'D', $cur_Date );
                                        }
                                        if ( $cur_Date == $thisDay ) {
                                            if ( $item[ 'dynamic_end_time' ] != '' && $item[ 'dynamic_close_this' ] != 'yes' ) {
                                                $availabelStatus = 'Open-' .
                                                   $item[ 'dynamic_enter_day' ] . '-' .
                                                   $item[ 'dynamic_start_time' ] . '-' .
                                                   $item[ 'dynamic_end_time' ];
                                            } else {
                                                $availabelStatus = 'Closed-' .
                                                $item[ 'dynamic_enter_day' ];
                                            }
                                        }
                                        ?>
                </span>
            </span>
        </span>
    </div>
</div>
<?php
                }

                $officeStatus      = $settings[ 'dynamic_open_day' ];
                $officeStatusLogic = 'open';

                $exStats = explode( '-', $availabelStatus );
                if ( isset( $exStats[ '1' ] ) ) {
                    if ( $exStats[ '0' ] == 'Closed' ) {
                        $closeDay = ucwords( substr( $exStats[ '1' ], 0, 3 ) );
                    }
                }

                if ( isset( $closeDay ) ) {
                    if ( $closeDay == date( 'D' ) ) {
                        $officeStatus      = $settings[ 'dynamic_close_day' ];
                        $officeStatusLogic = 'close';
                    }
                }

                //by time
                if ( isset( $exStats[ '2' ] ) && isset( $exStats[ '3' ] ) ) {
                    $st_time  = strtotime( $exStats[ '2' ] );
                    $end_time = strtotime( $exStats[ '3' ] );
                    if ( $settings[ 'dynamic_timezone' ] == 'default' ) {
                        $cur_time = strtotime( $this->set_time_zone() );;
                    } else {
                        $cur_time = strtotime( $this->set_time_zone() );
                        $cur_time = strtotime( date( 'g:i:s A', $cur_time ) );
                    }
                    if ( $cur_time >= $st_time && $cur_time <= $end_time ) {
                        $officeStatus      = $settings[ 'dynamic_open_day' ];
                        $officeStatusLogic = 'open';
                    } else {
                        $officeStatus      = $settings[ 'dynamic_close_day' ];
                        $officeStatusLogic = 'close';
                    }
                }
			echo '</div>';
			?>
<div class="spe-live-status">
    <?php
				if ( $officeStatusLogic == 'open' ) {
					?>
    <div class="spe-alert-success">
        <a class="spe-alert-close"></a>
        <?php echo $officeStatus; ?>
    </div>
    <?php 
                } else { 
                    ?>
    <div class="spe-alert-danger">
        <a class="spe-alert-close"></a>
        <?php echo $officeStatus; ?>
    </div>
    <?php
				}
				?>
</div>
<?php
		}
        
	}


	// set time zone
	public function set_time_zone() {
		$settingsTimeZone = $this->get_settings_for_display();

		if ( $settingsTimeZone[ 'dynamic_timezone' ] != 'default' ) { // timezone default checking
			// dynamic_timezone
			if ( $settingsTimeZone[ 'dynamic_timezone' ] == 'custom' ) { // timezone custom checking
				$ct_input = ! empty( $settingsTimeZone[ 'custom_timezone_input' ] ) ? $settingsTimeZone[ 'custom_timezone_input' ] : '+6';
			} else {
				$ct_input = $settingsTimeZone[ 'dynamic_timezone' ];
			}

			return $this->set_gmt_zone( $ct_input );
		} else {
			return $this->set_gmt_zone( get_option( 'gmt_offset' ) );
		}
	}


	// set gmt zone
	public function set_gmt_zone( $offset_minutes ) {
		$minutes          = 60 * $offset_minutes;
		$sign             = $minutes < 0 ? "-" : "+";
		$absolute_minutes = abs( $minutes );
		$timezone         = sprintf( "%s%02d", $sign, $absolute_minutes / 60, $absolute_minutes % 60 );

		$current_timestamp = time() + 3600 * ( $timezone + ( date( "I" ) ? 1 : 0 ) );
		$formatted_time    = gmdate( "g:i:s A", $current_timestamp );

		return $formatted_time;
	}

}