<?php
/**
 * Use namespace to avoid conflict
 */

namespace SPEL_PRO\Widgets;

use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Accordion_Article
 *
 * @package spider\Widgets
 * @since   1.0.0
 */
class Accordion_Article extends Widget_Base {

	public function get_name() {
		return 'spel_accordion_article'; // ID of the widget (Don't change this id)
	}

	public function get_title() {
		return esc_html__( 'Accordion Articles', 'spider-elements-pro' );
	}


	public function get_icon() {
		return 'eicon-accordion spel-icon';
	}

	public function get_keywords(): array {
		return [ 'spider', 'accordion', 'article', 'post', 'category' ];
	}

	public function get_categories(): array {
		return [ 'spider-element-pro' ];
	}

	/**
	 * Name: get_style_depends()
	 * Desc: Register the required CSS dependencies for the frontend.
	 */
	public function get_style_depends(): array {
		return [ 'spel-main', 'spel-main-pro' ];
	}

	/**
	 * Name: get_script_depends()
	 * Desc: Register the required JS dependencies for the frontend.
	 */
	public function get_script_depends(): array
    {
		return [ 'spel-el-pro-widgets' ];
	}

	/**
	 * Name: register_controls()
	 * Desc: Register controls for these widgets
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @spider-elements-pro
	 * Author: spider-themes
	 */
	protected function register_controls() {
		$this->elementor_content_control();
		$this->elementor_style_control();
	}

	/**
	 * Name: elementor_content_control()
	 * Desc: Register the Content Tab output on the Elementor editor.
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @spider-elements-pro
	 * Author: spider-themes
	 */
	public function elementor_content_control() {

		/** ============ Title Section ============ **/
		$this->start_controls_section(
			'style_sec', [
				'label' => esc_html__( 'Article Accordion', 'spider-elements-pro' ),
			]
		);
		$this->add_control(
			'column_grid', [
				'label'   => esc_html__( 'Column', 'spider-elements-pro' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'6' => esc_html__( 'Two Column', 'spider-elements-pro' ),
					'4' => esc_html__( 'Three Column', 'spider-elements-pro' ),
					'3' => esc_html__( 'Four Column', 'spider-elements-pro' ),
					'2' => esc_html__( 'Six Column', 'spider-elements-pro' ),
				],
				'default' => '4',
			]
		);

		$this->add_control(
			'cat_name', [
				'label'   => esc_html__( 'Select category (Blog Post)', 'spider-elements-pro' ),
				'type'    => Controls_Manager::SELECT,
				'options' => spel_cat_ids(),
				'default' => '',
			]
		);

		$this->add_control(
			'show_count', [
				'label'   => esc_html__( 'Show Posts Count', 'spider-elements-pro' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3
			]
		);

		$this->add_control(
			'order', [
				'label'   => esc_html__( 'Order', 'spider-elements-pro' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'ASC'  => 'ASC',
					'DESC' => 'DESC'
				],
				'default' => 'ASC'
			]
		);

		$this->add_control(
			'orderby', [
				'label'   => esc_html__( 'Order By', 'spider-elements-pro' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'none'   => 'None',
					'ID'     => 'ID',
					'author' => 'Author',
					'title'  => 'Title',
					'name'   => 'Name (by post slug)',
					'date'   => 'Date',
					'rand'   => 'Random',
				],
				'default' => 'none'
			]
		);

		$this->add_control(
			'title_length', [
				'label'   => esc_html__( 'Title Length', 'spider-elements-pro' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => - 1,
			]
		);

		$this->add_control(
			'excerpt_length', [
				'label'   => esc_html__( 'Excerpt Word Length', 'spider-elements-pro' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 15,
			]
		);

		$this->add_control(
			'exclude', [
				'label'       => esc_html__( 'Exclude', 'spider-elements-pro' ),
				'description' => esc_html__( 'Enter the post IDs to hide/exclude. Input the multiple ID with comma separated', 'spider-elements-pro' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$this->add_control(
			'collapse_state', [
				'label'        => esc_html__( 'Expanded', 'spider-elements-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', 'spider-elements-pro' ),
				'label_off'    => esc_html__( 'No', 'spider-elements-pro' ),
				'return_value' => 'yes',
				'separator'    => 'before',
			]
		);

		$this->add_control(
			'plus_icon', [
				'label'       => esc_html__( 'Icon', 'spider-elements-pro' ),
				'type'        => Controls_Manager::ICONS,
				'label_block' => true,
				'default'     => [
					'value'   => 'icon_plus',
					'library' => 'solid',
				],
				'separator'   => 'before'
			]
		);

		$this->add_control(
			'minus_icon', [
				'label'   => esc_html__( 'Active Icon', 'spider-elements-pro' ),
				'type'    => Controls_Manager::ICONS,
				'default' => [
					'value'   => 'icon_minus-06',
					'library' => 'solid',
				]
			]
		);

		$this->add_control(
			'icon_align',
			[
				'label'   => esc_html__( 'Icon Alignment', 'spider-elements-pro' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left'  => [
						'title' => esc_html__( 'Start', 'spider-elements-pro' ),
						'icon'  => 'eicon-h-align-left'
					],
					'right' => [
						'title' => esc_html__( 'End', 'spider-elements-pro' ),
						'icon'  => 'eicon-h-align-right'
					],
				],
				'default' => is_rtl() ? 'left' : 'right',
				'toggle'  => false,
			]
		);

		$this->add_responsive_control(
			'icon_space', [
				'label'      => esc_html__( 'Icon Spacing', 'spider-elements-pro' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em' ],
				'range'      => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
				],
				'default'    => [
					'size' => 30,
					'unit' => 'px',
				],
				'selectors'  => [
					'{{WRAPPER}} .tab-title .icon-wrapper i'         => 'margin-right: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .icon-align-left .icon-wrapper i'   => 'margin-left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .tab-title .icon-wrapper svg'       => 'right: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .icon-align-left .icon-wrapper svg' => 'left: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

	}


	/**
	 * Name: elementor_style_control()
	 * Desc: Register the Style Tab output on the Elementor editor.
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @spider-elements-pro
	 * Author: spider-themes
	 */
	public function elementor_style_control(): void {

		//========================= Start Title section =========================//
		$this->start_controls_section(
			'style_title_sec', [
				'label' => esc_html__( 'Tab Title', 'spider-elements-pro' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		// Tab Title Normal/Active State
		$this->start_controls_tabs(
			'style_tab_title'
		);

		//=== Normal Tab Title
		$this->start_controls_tab(
			'style_title_normal', [
				'label' => esc_html__( 'Normal', 'spider-elements-pro' ),
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(), [
				'name'     => 'title_normal_bg_color',
				'types'    => [ 'classic', 'gradient' ],
				'exclude'  => [ 'image' ],
				'selector' => '{{WRAPPER}} .article-inner .tab-title',
			]
		);

		$this->add_control(
			'title_normal_text_color', [
				'label'     => esc_html__( 'Text Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .tab-title' => 'color: {{VALUE}}',
				)
			]
		);

		$this->end_controls_tab(); // End normal Tab Title

		//=== Active Tab Title
		$this->start_controls_tab(
			'style_title_active', [
				'label' => esc_html__( 'Active', 'spider-elements-pro' ),
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(), [
				'name'     => 'title_active_bg_color',
				'types'    => [ 'classic', 'gradient' ],
				'exclude'  => [ 'image' ],
				'selector' => '{{WRAPPER}} .article-inner .active',
			]
		);

		$this->add_control(
			'title_active_text_color', [
				'label'     => esc_html__( 'Text Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .tab-title.active' => 'color: {{VALUE}};',
				)
			]
		);

		$this->add_control(
			'title_active_border_color',
			[
				'label'     => esc_html__( 'Border Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .article-inner' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab(); // End Active Tab Title

		$this->end_controls_tabs(); //End Normal/Active State Tab Title

		$this->add_control(
			'tab_title_divider', [
				'type' => Controls_Manager::DIVIDER,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'     => 'tab_title_typo',
				'selector' => '{{WRAPPER}} .tab-title',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(), [
				'name'     => 'tab_border',
				'label'    => esc_html__( 'Border', 'spider-elements-pro' ),
				'selector' => '{{WRAPPER}} .article-inner',
			]
		);

		$this->add_responsive_control(
			'tab_border_radius', [
				'label'      => esc_html__( 'Border Radius', 'spider-elements-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .article-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'title_padding', [
				'label'      => esc_html__( 'Padding', 'spider-elements-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .spel-accordion-article-wrap .tab-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(), [
				'name'     => 'feature_box_shadow',
				'selector' => '{{WRAPPER}} .article-inner',
			]
		);

		$this->end_controls_section(); // End Tab Title


		//======================== Tab Icon =========================//
		$this->start_controls_section(
			'icon_style', [
				'label' => esc_html__( 'Icon', 'spider-elements-pro' ),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_responsive_control(
			'icon_size', [
				'label'      => esc_html__( 'Icon Size', 'spider-elements-pro' ),
				'type'       => Controls_Manager::SLIDER,
				'separator'  => 'before',
				'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
				'range'      => [
					'px' => [
						'min' => 6,
						'max' => 300,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .icon-wrapper i'   => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .icon-wrapper svg' => 'height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		// Accordion icon Normal/Active/ State
		$this->start_controls_tabs(
			'style_icon_tabs'
		);

		//=== Normal icon
		$this->start_controls_tab(
			'style_icon_normal', [
				'label' => esc_html__( 'Normal', 'spider-elements-pro' ),
			]
		);

		$this->add_control(
			'normal_icon_color', [
				'label'     => esc_html__( 'Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .icon-wrapper .plus-icon i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .icon-wrapper svg'          => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'normal_icon_bg_color', [
				'label'     => esc_html__( 'Background', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .icon-wrapper .plus-icon i' => 'background: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab(); //End Normal icon

		//=== Active icon====
		$this->start_controls_tab(
			'style_icon_active', [
				'label' => esc_html__( 'Active', 'spider-elements-pro' ),
			]
		);

		$this->add_control(
			'active_icon_color', [
				'label'     => esc_html__( 'Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tab-title.active .minus-icon i'   => 'color: {{VALUE}};',
					'{{WRAPPER}} .tab-title.active .minus-icon svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'active_icon_bg_color', [
				'label'     => esc_html__( 'Background', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tab-title.active .minus-icon i' => 'background: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->add_responsive_control(
			'icon_padding', [
				'label'      => esc_html__( 'Padding', 'spider-elements-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .icon-wrapper i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before'
			]
		);

		$this->add_responsive_control(
			'icon_border_radius', [
				'label'      => esc_html__( 'Radius', 'spider-elements-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .icon-wrapper i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);


		$this->end_controls_section(); // End Icon Style


		//=========== Tab Contents ===========//
		$this->start_controls_section(
			'box_content_sec', [
				'label' => esc_html__( 'Content Box', 'spider-elements-pro' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'box_background',
				'types'    => [ 'classic', 'gradient', ],
				'selector' => '{{WRAPPER}} .multi-collapse .card-body',

			]
		);

		$this->add_responsive_control(
			'box_content-pad', [
				'label'      => esc_html__( 'Padding', 'spider-elements-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .multi-collapse .card-body' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section(); // End Tab Title


		//========================= Start Post Contents style section =========================//
		$this->start_controls_section(
			'style_content_sec', [
				'label' => esc_html__( 'Post Contents', 'spider-elements-pro' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		//=== Post Title
		$this->add_control(
			'post_text_options', [
				'label'     => esc_html__( 'Title', 'spider-elements-pro' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'     => 'post_title_typo',
				'selector' => '{{WRAPPER}} .spel-accordion-article-wrap .multi-collapse .accordion-article-item .post_title',
			]
		);

		$this->add_control(
			'post_title_color', [
				'label'     => esc_html__( 'Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .spel-accordion-article-wrap .multi-collapse .accordion-article-item .post_title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'title_hover_color', [
				'label'     => esc_html__( 'Hover Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .spel-accordion-article-wrap .multi-collapse .accordion-article-item .post_title:hover' => 'color: {{VALUE}};',
				],
			]
		);//End Post Title

		//===Start Post Description
		$this->add_control(
			'post_content_options', [
				'label'     => esc_html__( 'Description', 'spider-elements-pro' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'     => 'post_content_typo',
				'selector' => '{{WRAPPER}} .multi-collapse .card-body P',
			]
		);

		$this->add_control(
			'post_content_color', [
				'label'     => esc_html__( 'Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .multi-collapse .card-body P' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'post_meta_color', [
				'label'     => esc_html__( 'Meta Color', 'spider-elements-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .spel-accordion-article-wrap .multi-collapse .card-body .post-meta li' => 'color: {{VALUE}};',
				],
			]
		);//End Post description


		// Box item Design option
		$this->add_control(
			'post_design_options', [
				'label'     => esc_html__( 'Item Box', 'spider-elements-pro' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'content_background',
				'types'    => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .accordion-article-item',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(), [
				'name'     => 'border',
				'label'    => esc_html__( 'Border', 'spider-elements-pro' ),
				'selector' => '{{WRAPPER}} .spel-accordion-article-wrap .multi-collapse .card-body .accordion-article-item',
			]
		);

		$this->add_responsive_control(
			'item_border_radius', [
				'label'      => esc_html__( 'Border Radius', 'spider-elements-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .spel-accordion-article-wrap .multi-collapse .card-body .accordion-article-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'post_content-mar', [
				'label'      => esc_html__( 'Margin', 'spider-elements-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .spel-accordion-article-wrap .multi-collapse .card-body .accordion-article-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'post_content_pad', [
				'label'      => esc_html__( 'Padding', 'spider-elements-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .spel-accordion-article-wrap .multi-collapse .card-body .accordion-article-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section(); // End box Contents section


		//========================= Accordion Box =========================//
		$this->start_controls_section(
			'style_accordion', [
				'label' => esc_html__( 'Accordion Box', 'spider-elements-pro' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'accordion_gap_item', [
				'label'      => esc_html__( 'Gap Between Item', 'spider-elements-pro' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range'      => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .article-inner + .article-inner' => 'margin-top: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();// End Accordion Box

	}

	/**
	 * Name: elementor_render()
	 * Desc: Render the widget output on the frontend.
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @spider-elements-pro
	 * Author: spider-themes
	 */
	protected function render(): void {
		$settings = $this->get_settings_for_display();
		extract( $settings ); //extract all settings array to variables converted to name of key

		$taxonomy = get_terms( array(
			'taxonomy'   => 'category',
			'hide_empty' => true,
			'include'    => $settings['cat_name']
		) );

		$icon_align       = ! empty ( $settings['icon_align'] ) ? $settings['icon_align'] : 'right';
		$icon_align_class = ! empty ( $icon_align == 'left' ) ? ' icon-align-left' : '';
		$is_active        = $settings['collapse_state'] == 'yes' ? ' active' : '';
		$is_show          = $settings['collapse_state'] == 'yes' ? ' show' : '';

		//======================== Templates Parts ========================//
		include "templates/accordion-article/accordion-article.php";

	}
}