;(function ($, elementor) {
    "use strict";

    const $window = $(elementor);

    const spiderElementsPro = {

        onInit: function () {
            const E_FRONT = elementorFrontend;
            const widgetHandlersMap = {
                "docly_hotspot.default": spiderElementsPro.hotspot,
                "docy_flip_box.default": spiderElementsPro.flip_box,
                "spel_accordion_article.default": spiderElementsPro.accordionArticle,
                "spel_stacked_image.default": spiderElementsPro.stackImage,
                "spel_marquee_slider.default": spiderElementsPro.marqueeSlider,
            };

            $.each(widgetHandlersMap, function (widgetName, callback) {
                E_FRONT.hooks.addAction(
                    "frontend/element_ready/" + widgetName,
                    callback
                );
            });
        },

        /*============ Marquee Slider ==============*/
        marqueeSlider: function ($scope) {

            // Marquee Slider 01
            const marquee_1 = $scope.find('.marquee-slider-one .marquee-inner');

            if ( marquee_1.length > 0 ) {
                function createRowLoop($row, direction) {
                    let interval;

                    const startLoop = () => {
                        interval = setInterval(() => {
                            const firstChild = $row.find('.slide:first-child');
                            const marginDirection = direction === 'left' ? 'margin-left' : 'margin-right';
                            const currentMargin = parseInt(firstChild.css(marginDirection)) - 1;

                            firstChild.css(marginDirection, currentMargin);

                            if (Math.abs(currentMargin) >= firstChild.outerWidth()) {
                                firstChild.css(marginDirection, 0);
                                firstChild.appendTo($row);
                            }
                        }, 30);
                    };

                    const stopLoop = () => clearInterval(interval);

                    $row.data('startLoop', startLoop);
                    $row.data('stopLoop', stopLoop);
                    startLoop();
                }

                // Initialize sliding behavior for each row
                marquee_1.find('.slide-row').each(function () {
                    const direction = $(this).hasClass('left-slide') ? 'left' : 'right';
                    createRowLoop($(this), direction);
                });

                // Hover effect: Blur other logos and stop sliding
                marquee_1.find('.marquee_item').on('mouseenter', function () {
                    marquee_1.find('.slide-row').each(function () {
                        const stopLoop = $(this).data('stopLoop');
                        if (typeof stopLoop === 'function') stopLoop();
                    });
                    marquee_1.find('.marquee_item').addClass('blur'); // Apply blur class to all
                    $(this).removeClass('blur').addClass('focus'); // Highlight hovered logo
                }).on('mouseleave', function () {
                    marquee_1.find('.slide-row').each(function () {
                        const startLoop = $(this).data('startLoop');
                        if (typeof startLoop === 'function') startLoop();
                    });
                    marquee_1.find('.marquee_item').removeClass('blur focus'); // Reset blur and focus
                });
            }

            // Marquee Slider 02
            const marquee_2 = $scope.find('.marquee-slider-two .marquee-inner');

            if ( marquee_2.length > 0 ) {

                // Left-to-Right Slide
                marquee_2.find('.left-to-right').each(function () {
                    $(this).slick({
                        autoplay: true,
                        infinite: true,
                        slidesToShow: 3, // Number of items per row
                        slidesToScroll: 1,
                        dots: false,
                        speed: 5000,
                        cssEase: "linear",
                        autoplaySpeed: 10,
                        pauseOnHover: true,
                        responsive: [
                            {
                                breakpoint: 1024,
                                settings: {
                                    slidesToShow: 4,
                                },
                            },
                            {
                                breakpoint: 768,
                                settings: {
                                    slidesToShow: 3,
                                },
                            },
                            {
                                breakpoint: 576,
                                settings: {
                                    slidesToShow: 2,
                                },
                            },
                        ],
                    });
                });

                // Right-to-Left Slide
                marquee_2.find('.right-to-left').each(function () {
                    $(this).slick({
                        rtl: true, // Enable Right-to-Left Direction
                        autoplay: true,
                        infinite: true,
                        slidesToShow: 3, // Number of items per row
                        slidesToScroll: 1,
                        dots: false,
                        speed: 5000,
                        cssEase: "linear",
                        autoplaySpeed: 10,
                        pauseOnHover: true,
                        responsive: [
                            {
                                breakpoint: 1024,
                                settings: {
                                    slidesToShow: 4,
                                },
                            },
                            {
                                breakpoint: 768,
                                settings: {
                                    slidesToShow: 3,
                                },
                            },
                            {
                                breakpoint: 576,
                                settings: {
                                    slidesToShow: 2,
                                },
                            },
                        ],
                    });
                });
            }


            // Marquee Slider 03
            const marquee_3 = $('.marquee-slider-three .marquee_inner')
            if ( marquee_3.length > 0 ) {
                let Increment = 1; // Amount to move per tick...
                let LoopDelay = 500 / 30; // How fast ticks happen...?
                let Loop;

                function DestroyLoop() {
                    clearInterval(Loop);
                }

                function CreateLoop() {
                    Loop = setInterval(function () {
                        let FirstSlide = $(".marquee_inner .slide:first-child");
                        let FirstMargin = parseInt(FirstSlide.css("margin-left")) - Increment;
                        FirstSlide.css({ "margin-left": FirstMargin });

                        if (Math.abs(FirstMargin) >= FirstSlide.outerWidth()) {
                            FirstSlide.css({ "margin-left": 0 });
                            FirstSlide.appendTo($(".marquee_inner"));
                        }
                    }, LoopDelay);
                }

                marquee_3.on("mouseenter", DestroyLoop);
                marquee_3.on("mouseleave", CreateLoop);
                CreateLoop();
            }

        },


        /*================ Stack Image =====================*/
        stackImage: function ($scope) {

            let stackScroll = document.querySelector('.stack_scroll');
            if (stackScroll) {
                let mainWrapper = document.querySelector('.main-page-wrapper, .body_wrapper');
                if (mainWrapper) {
                    mainWrapper.style.overflow = 'visible';
                }
            }

        },


        /*============ Accordion Article ==============*/
        accordionArticle: function ($scope) {

            let tabTitle = $scope.find('.spel-accordion-article-wrap .tab-title');
            let tabContent = $scope.find('.spel-accordion-article-wrap .multi-collapse');

            tabTitle.on("click", function (event) {
                event.preventDefault(); // Prevent default behavior for anchor links

                let $this = $(this);
                let $content = $this.next('.multi-collapse'); // Find the corresponding content
                let isActive = $this.hasClass('active');

                if (isActive) {
                    // Collapse the clicked tab
                    $this.removeClass('active');
                    $content.removeClass('show').slideUp('slow');
                } else {

                    // Collapse all other tabs
                    tabTitle.removeClass('active');
                    tabContent.removeClass('show').slideUp('slow');

                    // Expand the clicked tab
                    $this.addClass('active');
                    $content.addClass('show').slideDown('slow');
                }
            });

        },


        //======================== Flip box =========================== //
        flip_box: function ($scope) {
            $(".flip_button").each(function (i) {
                $(this).on("click", function () {
                    $(".spe_flip_box_inner").eq(i).addClass("flip");
                });
            });

            $(".flip_button_close,.flip_overlay").on("click", function () {
                $(".spe_flip_box_inner").removeClass("flip");
            });
        },


        //======================== Hotspot ===========================//
        hotspot: function ($scope) {
            setInterval(function () {
                let active = $(".hotspot_list li.active");
                active.removeClass("active");
                if (active.next("li").length == 0) {
                    active
                        .parent(".hotspot_list")
                        .find("li:first-child")
                        .addClass("active");
                } else {
                    active.next("li").addClass("active");
                }
            }, 3000);

        },


    };

    $window.on("elementor/frontend/init", spiderElementsPro.onInit);
})(jQuery, window);