<?php
add_shortcode( 'terms', function ( $atts, $content ) {
	ob_start();

	$atts = shortcode_atts( array(
		'tax' => 'category',
	), $atts );

	// Validate taxonomy first
	if ( ! taxonomy_exists( $atts['tax'] ) ) {
		echo '<div class="docy-shortcode-error">❌ Taxonomy "' . esc_html( $atts['tax'] ) . '" does not exist.</div>';
		return ob_get_clean();
	}
 
	$tags = get_terms( $atts['tax'] );

	if ( is_wp_error( $tags ) || empty( $tags ) ) {
		echo '<div class="docy-shortcode-info">ℹ️ No terms found for taxonomy "' . esc_html( $atts['tax'] ) . '".</div>';
		return ob_get_clean();
	}

	foreach ( $tags as $tag ) { ?>
        <div class="tag-wrapper bs-sm h:bs-md">
            <div class="tag-title">
                <h2><a href="<?php echo esc_url( get_term_link( $tag ) ); ?>"> <?php echo esc_html( $tag->name ); ?> </a></h2>
            </div>
            <div class="tag-content">
				<?php echo esc_html( $tag->description ); ?>
            </div>
        </div>
	<?php }

	return ob_get_clean();
});
