<?php
function docy_login_form_shortcode( $atts ) {
	// If user already logged in, return a message or redirect
	if ( is_user_logged_in() ) {
		return '<div class="login-already" style="color: green; margin-bottom: 15px;">' . esc_html__( 'You are already logged in.', 'docy-core' ) . '</div>';
	}

	// Extract shortcode attributes with defaults
	$atts = shortcode_atts( array(
		'redirect'             => '',
		'submit_label'         => esc_html__( 'Sign in', 'docy-core' ),
		'username_label'       => esc_html__( 'Username', 'docy-core' ),
		'password_label'       => esc_html__( 'Password', 'docy-core' ),
		'error_notice'         => esc_html__( 'Invalid username or password. Please try again.', 'docy-core' ),
		'username_placeholder' => esc_attr__( 'Enter your username', 'docy-core' ),
		'password_placeholder' => esc_attr__( 'Enter your password', 'docy-core' ),
		'button_color'         => '#1e73be', // Default button background color
		'button_text_color'    => '#ffffff', // default text color
		'button_position'      => 'left', // left, center, right
		'signup_link'          => '', // attribute for signup link
	), $atts );

	// Set redirect URL
	$redirect_url = ! empty( $atts['redirect'] ) ? $atts['redirect'] : get_permalink();

	// Determine button alignment based on 'button_position' attribute
	$button_alignment = 'text-align: center;'; // default
	if ( $atts['button_position'] === 'left' ) {
		$button_alignment = 'text-align: left;';
	} elseif ( $atts['button_position'] === 'right' ) {
		$button_alignment = 'text-align: right;';
	}

	ob_start();

    $form_args = array(
        'redirect' => $redirect_url,
        'label_username' => $atts['username_label'],
        'label_password' => $atts['password_label'],
        'label_remember' => esc_html__( 'Remember Me', 'docy-core' ),
        'label_log_in' => $atts['submit_label'],
        'form_id' => 'docy_login_form',
        'remember' => true,
        ''
    );

    wp_login_form($form_args);

    if ( ! empty( $atts['signup_link'] ) ) : ?>
        <div class="signup-text">
            <?php esc_html_e( 'Don’t have an account yet?', 'docy-core' ); ?>
            <a href="<?php echo esc_url( $atts['signup_link'] ); ?>">
                <?php esc_html_e( 'Sign up here', 'docy-core' ); ?>
            </a>
        </div>
    <?php endif; ?>
    <?php

	return ob_get_clean();
}

add_shortcode( 'docy_login_form', 'docy_login_form_shortcode' );

// Redirect to the referrer page after login
add_action( 'wp_login_failed', 'docy_login_failed_redirect' );

function docy_login_failed_redirect( $username ) {
	$referrer = wp_get_referer();
	if ( ! empty( $referrer ) && ! str_contains( $referrer, 'wp-login.php' ) ) {
		wp_redirect( add_query_arg( 'login', 'failed', $referrer ) );
		exit;
	}
}
