<?php

// Flat icons
function docy_flaticons() {
    return [
        'flaticon-target' => 'Target',
        'flaticon-lightbulb' => 'Light Bulb',
        'flaticon-mortarboard' => 'Mortar Board',
    ];
}

function docy_include_flaticons() {
    return array_keys(docy_flaticons());
}


/**
 * Simple Line Icon Library
 * @return array
 */
function docy_simple_line_icons() {
    $simple_line_icons = [
        'icon-user',
        'icon-people',
        'icon-user-female',
        'icon-user-follow',
        'icon-user-following',
        'icon-user-unfollow',
        'icon-login',
        'icon-logout',
        'icon-emotsmile',
        'icon-phone',
        'icon-call-end',
        'icon-call-in',
        'icon-call-out',
        'icon-map',
        'icon-location-pin',
        'icon-direction',
        'icon-directions',
        'icon-compass',
        'icon-layers',
        'icon-menu',
        'icon-list',
        'icon-options-vertica',
        'icon-options',
        'icon-arrow-down',
        'icon-arrow-left',
        'icon-arrow-right',
        'icon-arrow-up',
        'icon-arrow-up-circle',
        'icon-arrow-left-circ',
        'icon-arrow-right-cir',
        'icon-arrow-down-circ',
        'icon-check',
        'icon-clock',
        'icon-plus',
        'icon-minus',
        'icon-close',
        'icon-event',
        'icon-exclamation',
        'icon-organization',
        'icon-trophy',
        'icon-screen-smartpho',
        'icon-screen-desktop',
        'icon-plane',
        'icon-notebook',
        'icon-mustache',
        'icon-mouse',
        'icon-magnet',
        'icon-energy',
        'icon-disc',
        'icon-cursor',
        'icon-cursor-move',
        'icon-crop',
        'icon-chemistry',
        'icon-speedometer',
        'icon-shield',
        'icon-screen-tablet',
        'icon-magic-wand',
        'icon-hourglass',
        'icon-graduation',
        'icon-ghost',
        'icon-game-controller',
        'icon-fire',
        'icon-eyeglass',
        'icon-envelope-open',
        'icon-envelope-letter',
        'icon-bell',
        'icon-badge',
        'icon-anchor',
        'icon-wallet',
        'icon-vector',
        'icon-speech',
        'icon-puzzle',
        'icon-printer',
        'icon-present',
        'icon-playlist',
        'icon-pin',
        'icon-picture',
        'icon-handbag',
        'icon-globe-alt',
        'icon-globe',
        'icon-folder-alt',
        'icon-folder',
        'icon-film',
        'icon-feed',
        'icon-drop',
        'icon-drawer',
        'icon-docs',
        'icon-doc',
        'icon-diamond',
        'icon-cup',
        'icon-calculator',
        'icon-bubbles',
        'icon-briefcase',
        'icon-book-open',
        'icon-basket-loaded',
        'icon-basket',
        'icon-bag',
        'icon-action-undo',
        'icon-action-redo',
        'icon-wrench',
        'icon-umbrella',
        'icon-trash',
        'icon-tag',
        'icon-support',
        'icon-frame',
        'icon-size-fullscreen',
        'icon-size-actual',
        'icon-shuffle',
        'icon-share-alt',
        'icon-share',
        'icon-rocket',
        'icon-question',
        'icon-pie-chart',
        'icon-pencil',
        'icon-note',
        'icon-loop',
        'icon-home',
        'icon-grid',
        'icon-graph',
        'icon-microphone',
        'icon-music-tone-alt',
        'icon-music-tone',
        'icon-earphones-alt',
        'icon-earphones',
        'icon-equalizer',
        'icon-like',
        'icon-dislike',
        'icon-control-start',
        'icon-control-rewind',
        'icon-control-play',
        'icon-control-pause',
        'icon-control-forward',
        'icon-control-end',
        'icon-volume-1',
        'icon-volume-2',
        'icon-volume-off',
        'icon-calendar',
        'icon-bulb',
        'icon-chart',
        'icon-ban',
        'icon-bubble',
        'icon-camrecorder',
        'icon-camera',
        'icon-cloud-download',
        'icon-cloud-upload',
        'icon-envelope',
        'icon-eye',
        'icon-flag',
        'icon-heart',
        'icon-info',
        'icon-key',
        'icon-link',
        'icon-lock',
        'icon-lock-open',
        'icon-magnifier',
        'icon-magnifier-add',
        'icon-magnifier-remove',
        'icon-paper-clip',
        'icon-paper-plane',
        'icon-power',
        'icon-refresh',
        'icon-reload',
        'icon-settings',
        'icon-star',
        'icon-symbol-female',
        'icon-symbol-male',
        'icon-target',
        'icon-credit-card',
        'icon-paypal',
        'icon-social-tumblr',
        'icon-social-twitter',
        'icon-social-facebook',
        'icon-social-instagram',
        'icon-social-linkedin',
        'icon-social-pinterest',
        'icon-social-github',
        'icon-social-google',
        'icon-social-reddit',
        'icon-social-skype',
        'icon-social-dribbble',
        'icon-social-behance',
        'icon-social-foursqare',
        'icon-social-soundclou',
        'icon-social-spotify',
        'icon-social-stumbleup',
        'icon-social-youtube',
        'icon-social-dropbox',
        'icon-social-vkontakte',
    ];
    return docy_icon_array($simple_line_icons);
}

function docy_include_simple_line_icons() {
    return array_keys(docy_simple_line_icons());
}


/**
 * Elegant Icons
 */
function docy_elegant_icons() {
    $et_icons = 'arrow_up, arrow_down, arrow_left, arrow_right, arrow_left-up, arrow_right-up, arrow_right-down, arrow_left-down, arrow-up-down, arrow_up-down_alt, arrow_left-right_alt, arrow_left-right, arrow_expand_alt2, arrow_expand_alt, arrow_condense, arrow_expand, arrow_move, arrow_carrot-up, arrow_carrot-down, arrow_carrot-left, arrow_carrot-right, arrow_carrot-2up, arrow_carrot-2down, arrow_carrot-2left, arrow_carrot-2right, arrow_carrot-up_alt2, arrow_carrot-down_alt2, arrow_carrot-left_alt2, arrow_carrot-right_alt2, arrow_carrot-2up_alt2, arrow_carrot-2down_alt2, arrow_carrot-2left_alt2, arrow_carrot-2right_alt2, arrow_triangle-up, arrow_triangle-down, arrow_triangle-left, arrow_triangle-right, arrow_triangle-up_alt2, arrow_triangle-down_alt2, arrow_triangle-left_alt2, arrow_triangle-right_alt2, arrow_back, icon_minus-06, icon_plus, icon_close, icon_check, icon_minus_alt2, icon_plus_alt2, icon_close_alt2, icon_check_alt2, icon_zoom-out_alt, icon_zoom-in_alt, icon_search, icon_box-empty, icon_box-selected, icon_minus-box, icon_plus-box, icon_box-checked, icon_circle-empty, icon_circle-slelected, icon_stop_alt2, icon_stop, icon_pause_alt2, icon_pause, icon_menu, icon_menu-square_alt2, icon_menu-circle_alt2, icon_ul, icon_ol, icon_adjust-horiz, icon_adjust-vert, icon_document_alt, icon_documents_alt, icon_pencil, icon_pencil-edit_alt, icon_pencil-edit, icon_folder-alt, icon_folder-open_alt, icon_folder-add_alt, icon_info_alt, icon_error-oct_alt, icon_error-circle_alt, icon_error-triangle_alt, icon_question_alt2, icon_question, icon_comment_alt, icon_chat_alt, icon_vol-mute_alt, icon_volume-low_alt, icon_volume-high_alt, icon_quotations, icon_quotations_alt2, icon_clock_alt, icon_lock_alt, icon_lock-open_alt, icon_key_alt, icon_cloud_alt, icon_cloud-upload_alt, icon_cloud-download_alt, icon_image, icon_images, icon_lightbulb_alt, icon_gift_alt, icon_house_alt, icon_genius, icon_mobile, icon_tablet, icon_laptop, icon_desktop, icon_camera_alt, icon_mail_alt, icon_cone_alt, icon_ribbon_alt, icon_bag_alt, icon_creditcard, icon_cart_alt, icon_paperclip, icon_tag_alt, icon_tags_alt, icon_trash_alt, icon_cursor_alt, icon_mic_alt, icon_compass_alt, icon_pin_alt, icon_pushpin_alt, icon_map_alt, icon_drawer_alt, icon_toolbox_alt, icon_book_alt, icon_calendar, icon_film, icon_table, icon_contacts_alt, icon_headphones, icon_lifesaver, icon_piechart, icon_refresh, icon_link_alt, icon_link, icon_loading, icon_blocked, icon_archive_alt, icon_heart_alt, icon_star_alt, icon_star-half_alt, icon_star, icon_star-half, icon_tools, icon_tool, icon_cog, icon_cogs, arrow_up_alt, arrow_down_alt, arrow_left_alt, arrow_right_alt, arrow_left-up_alt, arrow_right-up_alt, arrow_right-down_alt, arrow_left-down_alt, arrow_condense_alt, arrow_expand_alt3, arrow_carrot_up_alt, arrow_carrot-down_alt, arrow_carrot-left_alt, arrow_carrot-right_alt, arrow_carrot-2up_alt, arrow_carrot-2dwnn_alt, arrow_carrot-2left_alt, arrow_carrot-2right_alt, arrow_triangle-up_alt, arrow_triangle-down_alt, arrow_triangle-left_alt, arrow_triangle-right_alt, icon_minus_alt, icon_plus_alt, icon_close_alt, icon_check_alt, icon_zoom-out, icon_zoom-in, icon_stop_alt, icon_menu-square_alt, icon_menu-circle_alt, icon_document, icon_documents, icon_pencil_alt, icon_folder, icon_folder-open, icon_folder-add, icon_folder_upload, icon_folder_download, icon_info, icon_error-circle, icon_error-oct, icon_error-triangle, icon_question_alt, icon_comment, icon_chat, icon_vol-mute, icon_volume-low, icon_volume-high, icon_quotations_alt, icon_clock, icon_lock, icon_lock-open, icon_key, icon_cloud, icon_cloud-upload, icon_cloud-download, icon_lightbulb, icon_gift, icon_house, icon_camera, icon_mail, icon_cone, icon_ribbon, icon_bag, icon_cart, icon_tag, icon_tags, icon_trash, icon_cursor, icon_mic, icon_compass, icon_pin, icon_pushpin, icon_map, icon_drawer, icon_toolbox, icon_book, icon_contacts, icon_archive, icon_heart, icon_profile, icon_group, icon_grid-2x2, icon_grid-3x3, icon_music, icon_pause_alt, icon_phone, icon_upload, icon_download, social_facebook, social_twitter, social_pinterest, social_googleplus, social_tumblr, social_tumbleupon, social_wordpress, social_instagram, social_dribbble, social_vimeo, social_linkedin, social_rss, social_deviantart, social_share, social_myspace, social_skype, social_youtube, social_picassa, social_googledrive, social_flickr, social_blogger, social_spotify, social_delicious, social_facebook_circle, social_twitter_circle, social_pinterest_circle, social_googleplus_circle, social_tumblr_circle, social_stumbleupon_circle, social_wordpress_circle, social_instagram_circle, social_dribbble_circle, social_vimeo_circle, social_linkedin_circle, social_rss_circle, social_deviantart_circle, social_share_circle, social_myspace_circle, social_skype_circle, social_youtube_circle, social_picassa_circle, social_googledrive_alt2, social_flickr_circle, social_blogger_circle, social_spotify_circle, social_delicious_circle, social_facebook_square, social_twitter_square, social_pinterest_square, social_googleplus_square, social_tumblr_square, social_stumbleupon_square, social_wordpress_square, social_instagram_square, social_dribbble_square, social_vimeo_square, social_linkedin_square, social_rss_square, social_deviantart_square, social_share_square, social_myspace_square, social_skype_square, social_youtube_square, social_picassa_square, social_googledrive_square, social_flickr_square, social_blogger_square, social_spotify_square, social_delicious_square, icon_printer, icon_calulator, icon_building, icon_floppy, icon_drive, icon_search-2, icon_id, icon_id-2, icon_puzzle, icon_like, icon_dislike, icon_mug, icon_currency, icon_wallet, icon_pens, icon_easel, icon_flowchart, icon_datareport, icon_briefcase, icon_shield, icon_percent, icon_globe, icon_globe-2, icon_target, icon_hourglass, icon_balance, icon_rook, icon_printer-alt, icon_calculator_alt, icon_building_alt, icon_floppy_alt, icon_drive_alt, icon_search_alt, icon_id_alt, icon_id-2_alt, icon_puzzle_alt, icon_like_alt, icon_dislike_alt, icon_mug_alt, icon_currency_alt, icon_wallet_alt, icon_pens_alt, icon_easel_alt, icon_flowchart_alt, icon_datareport_alt, icon_briefcase_alt, icon_shield_alt, icon_percent_alt, icon_globe_alt, icon_clipboard';
    $et_icons = explode( ', ', $et_icons);
    return docy_icon_array($et_icons, '', '_');
}

function docy_include_elegant_icons() {
    return array_keys(docy_elegant_icons());
}


/**
 * Themify Icon Library
 * @return array
 */
function docy_themify_icons() {
    return [
        'ti-wand' => esc_html__( 'Wand', 'docy-core'),
        'ti-volume' => esc_html__( 'Volume', 'docy-core'),
        'ti-user' => esc_html__( 'User', 'docy-core'),
        'ti-unlock' => esc_html__( 'Unlock', 'docy-core'),
        'ti-unlink' => esc_html__( 'Unlink', 'docy-core'),
        'ti-trash' => esc_html__( 'Trash', 'docy-core'),
        'ti-thought' => esc_html__( 'Thought', 'docy-core'),
        'ti-target' => esc_html__( 'Target', 'docy-core'),
        'ti-tag' => esc_html__( 'Tag', 'docy-core'),
        'ti-tablet' => esc_html__( 'Tablet', 'docy-core'),
        'ti-star' => esc_html__( 'Star', 'docy-core'),
        'ti-spray' => esc_html__( 'Spray', 'docy-core'),
        'ti-shopping-cart-full' => esc_html__( 'Shopping Cart Full', 'docy-core'),
        'ti-shopping-cart' => esc_html__( 'Shopping Cart', 'docy-core'),
        'ti-settings' => esc_html__( 'Settings', 'docy-core'),
        'ti-search' => esc_html__( 'Search', 'docy-core'),
        'ti-zoom-in' => esc_html__( 'Zoom In', 'docy-core'),
        'ti-zoom-out' => esc_html__( 'Zoom Out', 'docy-core'),
        'ti-cut' => esc_html__( 'Cut', 'docy-core'),
        'ti-ruler' => esc_html__( 'Ruler', 'docy-core'),
        'ti-ruler-pencil' => esc_html__( 'Ruler Pencil', 'docy-core'),
        'ti-ruler-alt' => esc_html__( 'Ruler alt', 'docy-core'),
        'ti-bookmark' => esc_html__( 'Bookmark', 'docy-core'),
        'ti-bookmark-alt' => esc_html__( 'Bookmark Alt', 'docy-core'),
        'ti-reload' => esc_html__( 'Reload', 'docy-core'),
        'ti-plus' => esc_html__( 'Plus', 'docy-core'),
        'ti-pin' => esc_html__( 'Pin', 'docy-core'),
        'ti-pencil' => esc_html__( 'Pencil', 'docy-core'),
        'ti-pencil-alt' => esc_html__( 'Pencil Alt', 'docy-core'),
        'ti-paint-roller' => esc_html__( 'Paint Roller', 'docy-core'),
        'ti-paint-bucket' => esc_html__( 'Paint Bucket', 'docy-core'),
        'ti-na' => esc_html__( 'Na', 'docy-core'),
        'ti-mobile' => esc_html__( 'Mobile', 'docy-core'),
        'ti-minus' => esc_html__( 'Minus', 'docy-core'),
        'ti-medall' => esc_html__( 'Medall', 'docy-core'),
        'ti-medall-alt' => esc_html__( 'Medall Alt', 'docy-core'),
        'ti-marker' => esc_html__( 'Marker', 'docy-core'),
        'ti-marker-alt' => esc_html__( 'Marker Alt', 'docy-core'),
        'ti-arrow-up' => esc_html__( 'Arrow Up', 'docy-core'),
        'ti-arrow-right' => esc_html__( 'Arrow Right', 'docy-core'),
        'ti-arrow-left' => esc_html__( 'Arrow Left', 'docy-core'),
        'ti-arrow-down' => esc_html__( 'Arrow Down', 'docy-core'),
        'ti-lock' => esc_html__( 'Lock', 'docy-core'),
        'ti-location-arrow' => esc_html__( 'Location Arrow', 'docy-core'),
        'ti-link' => esc_html__( 'Link', 'docy-core'),
        'ti-layout' => esc_html__( 'Layout', 'docy-core'),
        'ti-layers' => esc_html__( 'Layers', 'docy-core'),
        'ti-layers-alt' => esc_html__( 'Layers Alt', 'docy-core'),
        'ti-key' => esc_html__( 'Key', 'docy-core'),
        'ti-import' => esc_html__( 'Import', 'docy-core'),
        'ti-image' => esc_html__( 'Image', 'docy-core'),
        'ti-heart' => esc_html__( 'Heart', 'docy-core'),
        'ti-heart-broken' => esc_html__( 'Heart Broken', 'docy-core'),
        'ti-hand-stop' => esc_html__( 'Hand Stop', 'docy-core'),
        'ti-hand-open' => esc_html__( 'Hand Open', 'docy-core'),
        'ti-hand-drag' => esc_html__( 'Hand Drag', 'docy-core'),
        'ti-folder' => esc_html__( 'Folder', 'docy-core'),
        'ti-flag' => esc_html__( 'Flag', 'docy-core'),
        'ti-flag-alt' => esc_html__( 'Flag Alt', 'docy-core'),
        'ti-flag-alt-2' => esc_html__( 'Flag Alt 2', 'docy-core'),
        'ti-eye' => esc_html__( 'Eye', 'docy-core'),
        'ti-export' => esc_html__( 'Export', 'docy-core'),
        'ti-exchange-vertical' => esc_html__( 'Exchange Vertical', 'docy-core'),
        'ti-desktop' => esc_html__( 'Desktop', 'docy-core'),
        'ti-cup' => esc_html__( 'Cup', 'docy-core'),
        'ti-crown' => esc_html__( 'Crown', 'docy-core'),
        'ti-comments' => esc_html__( 'Comments', 'docy-core'),
        'ti-comment' => esc_html__( 'Comment', 'docy-core'),
        'ti-comment-alt' => esc_html__( 'Comment Alt', 'docy-core'),
        'ti-close' => esc_html__( 'Close', 'docy-core'),
        'ti-clip' => esc_html__( 'Clip', 'docy-core'),
        'ti-angle-up' => esc_html__( 'Angle Up', 'docy-core'),
        'ti-angle-right' => esc_html__( 'Angle Right', 'docy-core'),
        'ti-angle-left' => esc_html__( 'Angle Left', 'docy-core'),
        'ti-angle-down' => esc_html__( 'Angle Down', 'docy-core'),
        'ti-check' => esc_html__( 'Check', 'docy-core'),
        'ti-check-box' => esc_html__( 'Check Box', 'docy-core'),
        'ti-camera' => esc_html__( 'Camera', 'docy-core'),
        'ti-announcement' => esc_html__( 'Announcement', 'docy-core'),
        'ti-brush' => esc_html__( 'Brush', 'docy-core'),
        'ti-briefcase' => esc_html__( 'Briefcase', 'docy-core'),
        'ti-bolt' => esc_html__( 'Bolt', 'docy-core'),
        'ti-bolt-alt' => esc_html__( 'Bolt Alt', 'docy-core'),
        'ti-blackboard' => esc_html__( 'Blackboard', 'docy-core'),
        'ti-bag' => esc_html__( 'Bag', 'docy-core'),
        'ti-move' => esc_html__( 'Move', 'docy-core'),
        'ti-arrows-vertical' => esc_html__( 'Arrows Vertical', 'docy-core'),
        'ti-arrows-horizontal' => esc_html__( 'Arrows Horizontal', 'docy-core'),
        'ti-fullscreen' => esc_html__( 'Fullscreen', 'docy-core'),
        'ti-arrow-top-right' => esc_html__( 'Arrow Top Right', 'docy-core'),
        'ti-arrow-top-left' => esc_html__( 'Arrow Top Left', 'docy-core'),
        'ti-arrow-circle-up' => esc_html__( 'Arrow Circle Up', 'docy-core'),
        'ti-arrow-circle-right' => esc_html__( 'Arrow Circle Right', 'docy-core'),
        'ti-arrow-circle-left' => esc_html__( 'Arrow Circle Left', 'docy-core'),
        'ti-arrow-circle-down' => esc_html__( 'Arrow Circle Down', 'docy-core'),
        'ti-angle-double-up' => esc_html__( 'Angle Double Up', 'docy-core'),
        'ti-angle-double-right' => esc_html__( 'Angle Double Right', 'docy-core'),
        'ti-angle-double-left' => esc_html__( 'Angle Double Left', 'docy-core'),
        'ti-angle-double-down' => esc_html__( 'Angle Double Down', 'docy-core'),
        'ti-zip' => esc_html__( 'Zip', 'docy-core'),
        'ti-world' => esc_html__( 'World', 'docy-core'),
        'ti-wheelchair' => esc_html__( 'Wheelchair', 'docy-core'),
        'ti-view-list' => esc_html__( 'View List', 'docy-core'),
        'ti-view-list-alt' => esc_html__( 'View List Alt', 'docy-core'),
        'ti-view-grid' => esc_html__( 'View Grid', 'docy-core'),
        'ti-uppercase' => esc_html__( 'Uppercase', 'docy-core'),
        'ti-upload' => esc_html__( 'Upload', 'docy-core'),
        'ti-underline' => esc_html__( 'Underline', 'docy-core'),
        'ti-truck' => esc_html__( 'Truck', 'docy-core'),
        'ti-timer' => esc_html__( 'Timer', 'docy-core'),
        'ti-ticket' => esc_html__( 'Ticket', 'docy-core'),
        'ti-thumb-up' => esc_html__( 'Thumb Up', 'docy-core'),
        'ti-thumb-down' => esc_html__( 'Thumb Down', 'docy-core'),
        'ti-text' => esc_html__( 'Text', 'docy-core'),
        'ti-stats-up' => esc_html__( 'Stats Up', 'docy-core'),
        'ti-stats-down' => esc_html__( 'Stats Down', 'docy-core'),
        'ti-split-v' => esc_html__( 'Split V', 'docy-core'),
        'ti-split-h' => esc_html__( 'Split-h', 'docy-core'),
        'ti-smallcap' => esc_html__( 'Smallcap', 'docy-core'),
        'ti-shine' => esc_html__( 'Shine', 'docy-core'),
        'ti-shift-right' => esc_html__( 'Shift Right', 'docy-core'),
        'ti-shift-left' => esc_html__( 'Shift Left', 'docy-core'),
        'ti-shield' => esc_html__( 'Shield', 'docy-core'),
        'ti-notepad' => esc_html__( 'Notepad', 'docy-core'),
        'ti-server' => esc_html__( 'Server', 'docy-core'),
        'ti-quote-right' => esc_html__( 'Quote Right', 'docy-core'),
        'ti-quote-left' => esc_html__( 'Quote Left', 'docy-core'),
        'ti-pulse' => esc_html__( 'Pulse', 'docy-core'),
        'ti-printer' => esc_html__( 'Printer', 'docy-core'),
        'ti-power-off' => esc_html__( 'Power Off', 'docy-core'),
        'ti-plug' => esc_html__( 'Plug', 'docy-core'),
        'ti-pie-chart' => esc_html__( 'Pie Chart', 'docy-core'),
        'ti-paragraph' => esc_html__( 'Paragraph', 'docy-core'),
        'ti-panel' => esc_html__( 'Panel', 'docy-core'),
        'ti-package' => esc_html__( 'Package', 'docy-core'),
        'ti-music' => esc_html__( 'Music', 'docy-core'),
        'ti-music-alt' => esc_html__( 'Music Alt', 'docy-core'),
        'ti-mouse' => esc_html__( 'Mouse', 'docy-core'),
        'ti-mouse-alt' => esc_html__( 'Mouse Alt', 'docy-core'),
        'ti-money' => esc_html__( 'Money', 'docy-core'),
        'ti-microphone' => esc_html__( 'Microphone', 'docy-core'),
        'ti-menu' => esc_html__( 'Menu', 'docy-core'),
        'ti-menu-alt' => esc_html__( 'Menu Alt', 'docy-core'),
        'ti-map' => esc_html__( 'Map', 'docy-core'),
        'ti-map-alt' => esc_html__( 'Map Alt', 'docy-core'),
        'ti-loop' => esc_html__( 'Loop', 'docy-core'),
        'ti-location-pin' => esc_html__( 'Location Pin', 'docy-core'),
        'ti-list' => esc_html__( 'List', 'docy-core'),
        'ti-light-bulb' => esc_html__( 'Light Bulb', 'docy-core'),
        'ti-Italic' => esc_html__( 'Italic', 'docy-core'),
        'ti-info' => esc_html__( 'Info', 'docy-core'),
        'ti-infinite' => esc_html__( 'Infinite', 'docy-core'),
        'ti-id-badge' => esc_html__( 'Badge', 'docy-core'),
        'ti-hummer' => esc_html__( 'Hummer', 'docy-core'),
        'ti-home' => esc_html__( 'Home', 'docy-core'),
        'ti-help' => esc_html__( 'Help', 'docy-core'),
        'ti-headphone' => esc_html__( 'Headphone', 'docy-core'),
        'ti-harddrives' => esc_html__( 'Harddrives', 'docy-core'),
        'ti-harddrive' => esc_html__( 'Harddrive', 'docy-core'),
        'ti-gift' => esc_html__( 'Gift', 'docy-core'),
        'ti-game' => esc_html__( 'Game', 'docy-core'),
        'ti-filter' => esc_html__( 'Filter', 'docy-core'),
        'ti-files' => esc_html__( 'Files', 'docy-core'),
        'ti-file' => esc_html__( 'File', 'docy-core'),
        'ti-eraser' => esc_html__( 'Eraser', 'docy-core'),
        'ti-envelope' => esc_html__( 'Envelope', 'docy-core'),
        'ti-download' => esc_html__( 'Download', 'docy-core'),
        'ti-direction' => esc_html__( 'Direction', 'docy-core'),
        'ti-direction-alt' => esc_html__( 'Direction Alt', 'docy-core'),
        'ti-dashboard' => esc_html__( 'Dashboard', 'docy-core'),
        'ti-control-stop' => esc_html__( 'Control Stop', 'docy-core'),
        'ti-control-shuffle' => esc_html__( 'Control Shuffle', 'docy-core'),
        'ti-control-play' => esc_html__( 'Control Play', 'docy-core'),
        'ti-control-pause' => esc_html__( 'Control Pause', 'docy-core'),
        'ti-control-forward' => esc_html__( 'Control Forward', 'docy-core'),
        'ti-control-backward' => esc_html__( 'Control Backward', 'docy-core'),
        'ti-cloud' => esc_html__( 'Cloud', 'docy-core'),
        'ti-cloud-up' => esc_html__( 'Cloud-up', 'docy-core'),
        'ti-cloud-down' => esc_html__( 'Cloud Down', 'docy-core'),
        'ti-clipboard' => esc_html__( 'Clipboard', 'docy-core'),
        'ti-car' => esc_html__( 'Car', 'docy-core'),
        'ti-calendar' => esc_html__( 'Calendar', 'docy-core'),
        'ti-book' => esc_html__( 'Book', 'docy-core'),
        'ti-bell' => esc_html__( 'Bell', 'docy-core'),
        'ti-basketball' => esc_html__( 'Basketball', 'docy-core'),
        'ti-bar-chart' => esc_html__( 'Bar Chart', 'docy-core'),
        'ti-bar-chart-alt' => esc_html__( 'Bar Chart Alt', 'docy-core'),
        'ti-back-right' => esc_html__( 'Back Right', 'docy-core'),
        'ti-back-left' => esc_html__( 'Back Left', 'docy-core'),
        'ti-arrows-corner' => esc_html__( 'Arrows Corner', 'docy-core'),
        'ti-archive' => esc_html__( 'Archive', 'docy-core'),
        'ti-anchor' => esc_html__( 'Anchor', 'docy-core'),
        'ti-align-right' => esc_html__( 'Align Right', 'docy-core'),
        'ti-align-left' => esc_html__( 'Align Left', 'docy-core'),
        'ti-align-justify' => esc_html__( 'Align Justify', 'docy-core'),
        'ti-align-center' => esc_html__( 'Align Center', 'docy-core'),
        'ti-alert' => esc_html__( 'Alert', 'docy-core'),
        'ti-alarm-clock' => esc_html__( 'Alarm Clock', 'docy-core'),
        'ti-agenda' => esc_html__( 'Agenda', 'docy-core'),
        'ti-write' => esc_html__( 'Write', 'docy-core'),
        'ti-window' => esc_html__( 'Window', 'docy-core'),
        'ti-widgetized' => esc_html__( 'Widgetized', 'docy-core'),
        'ti-widget' => esc_html__( 'Widget', 'docy-core'),
        'ti-widget-alt' => esc_html__( 'Widget Alt', 'docy-core'),
        'ti-wallet' => esc_html__( 'Wallet', 'docy-core'),
        'ti-video-clapper' => esc_html__( 'Video Clapper', 'docy-core'),
        'ti-video-camera' => esc_html__( 'Video Camera', 'docy-core'),
        'ti-vector' => esc_html__( 'Vector', 'docy-core'),
        'ti-themify-logo' => esc_html__( 'Themify Logo', 'docy-core'),
        'ti-themify-favicon' => esc_html__( 'Themify Favicon', 'docy-core'),
        'ti-themify-favicon-alt' => esc_html__( 'Themify Favicon Alt', 'docy-core'),
        'ti-support' => esc_html__( 'Support', 'docy-core'),
        'ti-stamp' => esc_html__( 'Stamp', 'docy-core'),
        'ti-split-v-alt' => esc_html__( 'Split V Alt', 'docy-core'),
        'ti-slice' => esc_html__( 'Slice', 'docy-core'),
        'ti-shortcode' => esc_html__( 'Shortcode', 'docy-core'),
        'ti-shift-right-alt' => esc_html__( 'Shift Right Alt', 'docy-core'),
        'ti-shift-left-alt' => esc_html__( 'Shift Left Alt', 'docy-core'),
        'ti-ruler-alt-2' => esc_html__( 'Ruler Alt 2', 'docy-core'),
        'ti-receipt' => esc_html__( 'Receipt', 'docy-core'),
        'ti-pin2' => esc_html__( 'Pin2', 'docy-core'),
        'ti-pin-alt' => esc_html__( 'Pin Alt', 'docy-core'),
        'ti-pencil-alt2' => esc_html__( 'Pencil Alt2', 'docy-core'),
        'ti-palette' => esc_html__( 'Palette', 'docy-core'),
        'ti-more' => esc_html__( 'More', 'docy-core'),
        'ti-more-alt' => esc_html__( 'More Alt', 'docy-core'),
        'ti-microphone-alt' => esc_html__( 'Microphone Alt', 'docy-core'),
        'ti-magnet' => esc_html__( 'Magnet', 'docy-core'),
        'ti-line-double' => esc_html__( 'Line Double', 'docy-core'),
        'ti-line-dotted' => esc_html__( 'Line Dotted', 'docy-core'),
        'ti-line-dashed' => esc_html__( 'Line Dashed', 'docy-core'),
        'ti-layout-width-full' => esc_html__( 'Layout Width Full', 'docy-core'),
        'ti-layout-width-default' => esc_html__( 'Layout Width Default', 'docy-core'),
        'ti-layout-width-default-alt' => esc_html__( 'Layout Width Default Alt', 'docy-core'),
        'ti-layout-tab' => esc_html__( 'Layout Tab', 'docy-core'),
        'ti-layout-tab-window' => esc_html__( 'Layout Tab Window', 'docy-core'),
        'ti-layout-tab-v' => esc_html__( 'Layout Tab V', 'docy-core'),
        'ti-layout-tab-min' => esc_html__( 'Layout Tab Min', 'docy-core'),
        'ti-layout-slider' => esc_html__( 'Layout Slider', 'docy-core'),
        'ti-layout-slider-alt' => esc_html__( 'Layout Slider Alt', 'docy-core'),
        'ti-layout-sidebar-right' => esc_html__( 'Layout Sidebar Right', 'docy-core'),
        'ti-layout-sidebar-none' => esc_html__( 'Layout Sidebar None', 'docy-core'),
        'ti-layout-sidebar-left' => esc_html__( 'Layout Sidebar Left', 'docy-core'),
        'ti-layout-placeholder' => esc_html__( 'Layout Placeholder', 'docy-core'),
        'ti-layout-menu' => esc_html__( 'Layout Menu', 'docy-core'),
        'ti-layout-menu-v' => esc_html__( 'layout Menu V', 'docy-core'),
        'ti-layout-menu-separated' => esc_html__( 'Layout Menu Separated', 'docy-core'),
        'ti-layout-menu-full' => esc_html__( 'Layout Menu Full', 'docy-core'),
        'ti-layout-media-right-alt' => esc_html__( 'Layout Media Right Alt', 'docy-core'),
        'ti-layout-media-right' => esc_html__( 'Layout Media Right', 'docy-core'),
        'ti-layout-media-overlay' => esc_html__( 'Layout Media Overlay', 'docy-core'),
        'ti-layout-media-overlay-alt' => esc_html__( 'Layout Media Overlay Alt', 'docy-core'),
        'ti-layout-media-overlay-alt-2' => esc_html__( 'Layout Media Overlay Alt 2', 'docy-core'),
        'ti-layout-media-left-alt' => esc_html__( 'Layout Media Left Alt', 'docy-core'),
        'ti-layout-media-left' => esc_html__( 'Layout Media Left', 'docy-core'),
        'ti-layout-media-center-alt' => esc_html__( 'Layout Media Center Alt', 'docy-core'),
        'ti-layout-media-center' => esc_html__( 'Layout Media Center', 'docy-core'),
        'ti-layout-list-thumb' => esc_html__( 'Layout List Thumb', 'docy-core'),
        'ti-layout-list-thumb-alt' => esc_html__( 'Layout List Thumb Alt', 'docy-core'),
        'ti-layout-list-post' => esc_html__( 'Layout List Post', 'docy-core'),
        'ti-layout-list-large-image' => esc_html__( 'Layout List Large Image', 'docy-core'),
        'ti-layout-line-solid' => esc_html__( 'Layout Line Solid', 'docy-core'),
        'ti-layout-grid4' => esc_html__( 'Layout Grid4', 'docy-core'),
        'ti-layout-grid3' => esc_html__( 'Layout Grid3', 'docy-core'),
        'ti-layout-grid2' => esc_html__( 'Layout Grid2', 'docy-core'),
        'ti-layout-grid2-thumb' => esc_html__( 'Layout Grid2 Thumb', 'docy-core'),
        'ti-layout-cta-right' => esc_html__( 'Layout Cta Right', 'docy-core'),
        'ti-layout-cta-left' => esc_html__( 'Layout Cta Left', 'docy-core'),
        'ti-layout-cta-center' => esc_html__( 'Layout Cta Center', 'docy-core'),
        'ti-layout-cta-btn-right' => esc_html__( 'Layout Cta Btn Right', 'docy-core'),
        'ti-layout-cta-btn-left' => esc_html__( 'Layout Cta Btn Left', 'docy-core'),
        'ti-layout-column4' => esc_html__( 'Layout Column4', 'docy-core'),
        'ti-layout-column3' => esc_html__( 'Layout Column3', 'docy-core'),
        'ti-layout-column2' => esc_html__( 'Layout Column2', 'docy-core'),
        'ti-layout-accordion-separated' => esc_html__( 'Layout Accordion Separated', 'docy-core'),
        'ti-layout-accordion-merged' => esc_html__( 'Layout Accordion Merged', 'docy-core'),
        'ti-layout-accordion-list' => esc_html__( 'Layout Accordion List', 'docy-core'),
        'ti-ink-pen' => esc_html__( 'Ink Pen', 'docy-core'),
        'ti-info-alt' => esc_html__( 'Info Alt', 'docy-core'),
        'ti-help-alt' => esc_html__( 'Help Alt', 'docy-core'),
        'ti-headphone-alt' => esc_html__( 'Headphone Alt', 'docy-core'),
        'ti-hand-point-up' => esc_html__( 'Hand Point Up', 'docy-core'),
        'ti-hand-point-right' => esc_html__( 'Hand Point Right', 'docy-core'),
        'ti-hand-point-left' => esc_html__( 'Hand Point Left', 'docy-core'),
        'ti-hand-point-down' => esc_html__( 'Hand Point Down', 'docy-core'),
        'ti-gallery' => esc_html__( 'Gallery', 'docy-core'),
        'ti-face-smile' => esc_html__( 'Face Smile', 'docy-core'),
        'ti-face-sad' => esc_html__( 'Face Sad', 'docy-core'),
        'ti-credit-card' => esc_html__( 'Credit Card', 'docy-core'),
        'ti-control-skip-forward' => esc_html__( 'Control Skip Forward', 'docy-core'),
        'ti-control-record' => esc_html__( 'Control Record', 'docy-core'),
        'Control-eject' => esc_html__( 'Control Eject', 'docy-core'),
        'ti-comments-smiley' => esc_html__( 'Comments Smiley', 'docy-core'),
        'ti-brush-alt' => esc_html__( 'Brush Alt', 'docy-core'),
        'ti-youtube' => esc_html__( 'Youtube', 'docy-core'),
        'ti-vimeo' => esc_html__( 'Vimeo', 'docy-core'),
        'ti-twitter' => esc_html__( 'Twitter', 'docy-core'),
        'ti-time' => esc_html__( 'Time', 'docy-core'),
        'ti-tumblr' => esc_html__( 'Tumblr', 'docy-core'),
        'ti-skype' => esc_html__( 'Skype', 'docy-core'),
        'ti-share' => esc_html__( 'Share', 'docy-core'),
        'ti-share-alt' => esc_html__( 'Share Alt', 'docy-core'),
        'ti-rocket' => esc_html__( 'Rocket', 'docy-core'),
        'ti-pinterest' => esc_html__( 'Pinterest', 'docy-core'),
        'ti-new-window' => esc_html__( 'New Window', 'docy-core'),
        'ti-microsoft' => esc_html__( 'Microsoft', 'docy-core'),
        'ti-list-ol' => esc_html__( 'List Ol', 'docy-core'),
        'ti-linkedin' => esc_html__( 'Linkedin', 'docy-core'),
        'ti-layout-sidebar-2' => esc_html__( 'Layout Sidebar-2', 'docy-core'),
        'ti-layout-grid4-alt' => esc_html__( 'Layout Grid4 Alt', 'docy-core'),
        'ti-layout-grid3-alt' => esc_html__( 'Layout Grid3 Alt', 'docy-core'),
        'ti-layout-grid2-alt' => esc_html__( 'Layout Grid2 Alt', 'docy-core'),
        'ti-layout-column4-alt' => esc_html__( 'Layout Column4 Alt', 'docy-core'),
        'ti-layout-column3-alt' => esc_html__( 'Layout Column3 Alt', 'docy-core'),
        'ti-layout-column2-alt' => esc_html__( 'Layout Column2 Alt', 'docy-core'),
        'ti-instagram' => esc_html__( 'Instagram', 'docy-core'),
        'ti-google' => esc_html__( 'Google', 'docy-core'),
        'ti-github' => esc_html__( 'Github', 'docy-core'),
        'ti-flickr' => esc_html__( 'Flickr', 'docy-core'),
        'ti-facebook' => esc_html__( 'Facebook', 'docy-core'),
        'ti-dropbox' => esc_html__( 'Dropbox', 'docy-core'),
        'ti-dribbble' => esc_html__( 'Dribbble', 'docy-core'),
        'ti-apple' => esc_html__( 'Apple', 'docy-core'),
        'ti-android' => esc_html__( 'Android', 'docy-core'),
        'ti-save' => esc_html__( 'Save', 'docy-core'),
        'ti-save-alt' => esc_html__( 'Save Alt', 'docy-core'),
        'ti-yahoo' => esc_html__( 'Yahoo', 'docy-core'),
        'ti-wordpress' => esc_html__( 'Wordpress', 'docy-core'),
        'ti-vimeo-alt' => esc_html__( 'Vimeo Alt', 'docy-core'),
        'ti-twitter-alt' => esc_html__( 'Twitter Alt', 'docy-core'),
        'ti-tumblr-alt' => esc_html__( 'Tumblr Alt', 'docy-core'),
        'ti-trello' => esc_html__( 'Trello', 'docy-core'),
        'ti-stack-overflow' => esc_html__( 'Stack Overflow', 'docy-core'),
        'ti-soundcloud' => esc_html__( 'Soundcloud', 'docy-core'),
        'ti-sharethis' => esc_html__( 'Sharethis', 'docy-core'),
        'ti-sharethis-alt' => esc_html__( 'Sharethis Alt', 'docy-core'),
        'ti-reddit' => esc_html__( 'Reddit', 'docy-core'),
        'ti-pinterest-alt' => esc_html__( 'Pinterest Alt', 'docy-core'),
        'ti-microsoft-alt' => esc_html__( 'Microsoft Alt', 'docy-core'),
        'ti-linux' => esc_html__( 'Linux', 'docy-core'),
        'ti-jsfiddle' => esc_html__( 'Jsfiddle', 'docy-core'),
        'ti-joomla' => esc_html__( 'Joomla', 'docy-core'),
        'ti-html5' => esc_html__( 'Html5', 'docy-core'),
        'ti-flickr-alt' => esc_html__( 'Flickr Alt', 'docy-core'),
        'ti-email' => esc_html__( 'Email', 'docy-core'),
        'ti-drupal' => esc_html__( 'Drupal', 'docy-core'),
        'ti-dropbox-alt' => esc_html__( 'Dropbox Alt', 'docy-core'),
        'ti-css3' => esc_html__( 'Css3', 'docy-core'),
        'ti-rss' => esc_html__( 'Rss', 'docy-core'),
        'ti-rss-alt' => esc_html__( 'Rss-alt', 'docy-core')
    ];
}

function docy_include_themify_icons() {
    return array_keys(docy_themify_icons());
}

/**
 * Elementor Icon Type
 */
function docy_icon_type( $settings_key = 'icon_type' ) {

    if ( !empty($settings[$settings_key]) ) {
	    switch ( $settings[ $settings_key ] ) {
		    case 'fontawesome':
			    $icon = ! empty( $settings['fontawesome'] ) ? $settings['fontawesome'] : '';
			    break;
		    case 'eicon':
			    $icon = ! empty( $settings['eicon'] ) ? $settings['eicon'] : '';
			    break;
		    case 'ticon':
			    $icon = ! empty( $settings['ticon'] ) ? $settings['ticon'] : '';
			    break;
		    case 'slicon':
			    wp_enqueue_style( 'simple-line-icon' );
			    $icon = ! empty( $settings['slicon'] ) ? $settings['slicon'] : '';
			    break;
		    case 'flaticon':
			    $icon = ! empty( $settings['flaticon'] ) ? $settings['flaticon'] : '';
			    break;
	    }
	    $icon_class = ( ! empty( $icon ) ) ? "class='$icon'" : '';
    } else {
	    $icon_class = '';
    }
    return $icon_class;
}