<?php
/**
 * @package Zero Configuration with @wordpress/create-block
 *  [boilerplate] && [BOILERPLATE] ===> Prefix
 */

// Stop Direct Access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Blocks Final Class
 */

final class DOCY_BLOCKS_CLASS {
    public function __construct() {
        // block initialization
        add_action( 'init', [ $this, 'blocks_init' ] );
    }

    /**
     * Initialize the plugin
     */
    public static function init(){
        static $instance = false;
        if( ! $instance ) {
            $instance = new self();
        }
        return $instance;
    }

    /**
     * Blocks Registration
     */
    public function register_block( $name, $options = array() ) {
        register_block_type( DOCY_PATH . '/build/' . $name, $options );
    }

    /**
     * Blocks Initialization
     */
    public function blocks_init() {
        $this->register_block( 'docy-toolbar' );            
    }
}

/**
 * Kickoff
 */
DOCY_BLOCKS_CLASS::init();